package ru.yandex.autotests.direct.web.pages.mediaplans.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 06.12.13
 * Строка итоговых прогнозов баннера по всем фразам
 */

@FindBy(xpath = ".//tr[contains(@class, 'b-phrases-list-total b-phrases-list-total-bem-deffered i-bem " +
        "b-phrases-list-total_js_inited')]")
public class MediaplanTotalForecastRowBlock extends HtmlElement {

    @Name("Итоговый прогноз CTR")
    @FindBy(xpath = ".//div[contains(@class,'b-phrases-list-total__ctr total')]")
    private WebElement totalCTRForecast;

    @Name("Итоговый прогноз показов")
    @FindBy(xpath = ".//div[contains(@class, 'b-phrases-list-total__shows')]")
    private WebElement totalShowsForecast;

    @Name("Итоговый прогноз кликов")
    @FindBy(xpath = ".//div[contains(@class, 'b-phrases-list-total__clicks')]")
    private WebElement totalClicksForecast;

    @Name("Итоговый прогноз бюджета")
    @FindBy(xpath = ".//div[contains(@class, 'b-phrases-list-total__budget')]")
    private WebElement totalBudgetForecast;

    public String getTotalCTRForecast() {
        return totalCTRForecast.getText().replace(" ", "");
    }

    public String getTotalShowsForecast() {
        return totalShowsForecast.getText().replace(" ", "");
    }

    public String getTotalClicksForecast() {
        return totalClicksForecast.getText().replace(" ", "");
    }

    public String getTotalBudgetForecast() {
        return totalBudgetForecast.getText().replaceAll("[^0-9.]", "").replaceAll(".$", "");
    }

    public String getBannerId() {
        Pattern pattern = Pattern.compile("banner:\\d+");
        Matcher matcher = pattern.matcher(this.getAttribute("onclick"));
        if (matcher.find()) {
            return matcher.group().replace("banner:", "");
        } else {
            return null;
        }
    }
}
