package ru.yandex.autotests.direct.web.pages.mediaplans.blocks;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

/**
 * User: alexey-n
 * Date: 11.09.13
 * Time: 16:31
 */
@FindBy(xpath = "//div[contains(@class,'i-popup')]//ul[.//span]")
public class PhrasesActionPopupBlock extends HtmlElement {

    @Name("Удалить все")
    @FindBy(xpath = ".//span[contains(@onclick, 'delete_all')]")
    private Link removeAllPhrases;

    @Name("Сделать первую букву строчной")
    @FindBy(xpath = ".//span[contains(@onclick, 'to_lower_case')]")
    private Link toLowerCaseFirstLetterAllPhrases;

    @Name("Сделать первую букву заглавной")
    @FindBy(xpath = ".//span[contains(@onclick, 'to_upper_case')]")
    private Link toUpperCaseFirstLetterAllPhases;

    @Name("Убрать кавычки")
    @FindBy(xpath = ".//span[contains(@onclick, 'unwrap_quotes')]")
    private Link unwrapQuotesAllPhrases;

    @Name("Поставить кавычки")
    @FindBy(xpath = ".//span[contains(@onclick, \"'wrap_quotes'\")]")
    private Link wrapQuotesAllPhrasesWithoutMinusKeywords;

    public void clickRemoveAllPhrases() {
        removeAllPhrases.click();
    }

    public void clickToLowerCaseFirstLetterAllPhrases() {
        toLowerCaseFirstLetterAllPhrases.click();
    }

    public void clickToUpperCaseFirstLetterAllPhases() {
        toUpperCaseFirstLetterAllPhases.click();
    }

    public void clickUnwrapQuotesAllPhrases() {
        unwrapQuotesAllPhrases.click();
    }

    public void clickWrapQuotesAllPhrases() {
        wrapQuotesAllPhrasesWithoutMinusKeywords.click();
    }
}
