package ru.yandex.autotests.direct.web.pages.payment;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;

import static org.hamcrest.MatcherAssert.assertThat;

public class BalanceCheckOutPage extends BasePageObject {

    @Name("Всего к оплате (новая страница баланса)")
    @FindBy(xpath = ".//div[contains(@class, 'yb-paystep-main-total__sum')]//span")
    private WebElement totalPayable;

    @Name("Всего к оплате (старая страница баланса)")
    @FindBy(xpath = "(.//div[contains(@class, 'money')])[1]")
    private WebElement totalPayable2;

    public void checkTotalPayable(Matcher matcher) {
        if (WebElementsActions.isExists(totalPayable)) {
            assertThat("общая сумма к оплате соответсвует ожиданиям", totalPayable.getText(), matcher);
        }
        else if (WebElementsActions.isExists(totalPayable2)) {
            assertThat("общая сумма к оплате соответсвует ожиданиям", totalPayable2.getText(), matcher);
        }
        else {
            throw new DirectWebError("Не удалось найти сумму оплаты");
        }
    }
}
