package ru.yandex.autotests.direct.web.pages.payment;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static org.hamcrest.CoreMatchers.endsWith;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.isDisplayed;

/**
 * User: buhter
 * Date: 24.06.13
 * Time: 13:22
 * Страница c кодом оплаты кампании наличными
 */
public class PayWithCashBalancePage extends BasePageObject {

    @Name("Код для оплаты наличными")
    @FindBy(xpath = "//div[@class='b-campany__number']")
    private WebElement paymentWithCashCode;

    @Name("Выставить счет")
    @FindBy(xpath = ".//input[@type='submit']")
    private Button billButton;

    private WebElement getPaymentWithCashCode() {
        return paymentWithCashCode;
    }

    public void isPaymentCodeDisplayed() {
        assertThat("не найден код для платежа для терминалов", isDisplayed(getPaymentWithCashCode()));
    }

    public void shouldSeePaymentCodeFor(Long c) {
        assertThat("неверный код для платежа для терминалов", getPaymentWithCashCode().getText().replace(" ", "")
                , endsWith(c.toString()));
    }

    public void clickOnBillButton() {
        billButton.click();
    }
}
