package ru.yandex.autotests.direct.web.pages.payment;

import org.hamcrest.Matcher;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextBlock;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;

@Name("Форма оплаты кампании на странице оплаты")
@FindBy(xpath = ".//div[contains(@class, 'b-pay__content') or contains(@class, 'p-pay__detail-container')]")
public class PaymentForm extends ExtendedHtmlElement {

    @Name("Поле суммы платежа  без НДС")
    @FindBy(css = "div.b-pay__sum-without-nds input")
    private TextInput payFormMoneyInput;

    @Name("Линк активизации поля суммы платежа  без НДС")
    @FindBy(css = "div.b-pay__sum-without-nds span.b-toggle-input__link")
    private Link payFormMoneyToggleLink;

    @Name("Поле суммы платежа с НДС")
    @FindBy(css = "div.b-pay__sum-with-nds input")
    private TextInput payFormMoneyWithVATInput;

    @Name("Линк активизации поля суммы платежа с НДС")
    @FindBy(css = "div.b-pay__sum-with-nds span.b-toggle-input__link")
    private Link payFormMoneyWithVATToggleLink;

    @Name("Кнопка 'Выписать счет'")
    @FindBy(css = "button.b-pay__submit")
    private Button submitButton;

    @Name("Ссылка 'оплатить кампанию наличными'")
    @FindBy(css = "div.b-pay__form-buttons a")
    private Link payWithCashLink;

    @Name("Прогнозируемое количество дней")
    @FindBy(css = "span.b-pay__easy-days")
    private TextBlock forecastDaysText;

    private TextInput getPayFormMoneyInput() {
        return payFormMoneyInput;
    }

    private Link getPayFormMoneyToggleLink() {
        return payFormMoneyToggleLink;
    }

    private TextInput getPayFormMoneyWithVATInput() {
        return payFormMoneyWithVATInput;
    }

    private Link getPayFormMoneyWithVATToggleLink() {
        return payFormMoneyWithVATToggleLink;
    }

    private Button getSubmitButton() {
        return submitButton;
    }

    private Link getPayWithCashLink() {
        return payWithCashLink;
    }


    public void setPaySum(float sum) {
        if (getPayFormMoneyToggleLink().isDisplayed()) {
            getPayFormMoneyToggleLink().click();
        }
        new WebElementsActions(config).fillTextInputWithClickAndEvents(getPayFormMoneyInput(), String.valueOf(sum));
    }

    public void setPayWithVATSum(float sum) {
        if (getPayFormMoneyWithVATToggleLink().isDisplayed()) {
            getPayFormMoneyWithVATToggleLink().click();
            takeScreenshot();
        }
        sleep(1000);
        new WebElementsActions(config).fillTextInputWithClickAndEvents(getPayFormMoneyWithVATInput(), String.valueOf(sum));
        takeScreenshot();
    }

    public float getPaymentSum() {
        return Float.parseFloat(payFormMoneyInput.getText().replaceAll("[^\\d\\.]", ""));
    }

    public void checkRequiredPaySum(Matcher<WrapsElement> matcher) {
        assertThat("рекомендуемая сумма для оплаты не соответствует ожиданиям", payFormMoneyInput, matcher);
    }

    public float getPaymentWithVATSum() {
        return Float.parseFloat(payFormMoneyWithVATInput.getText().replaceAll("[^\\d\\.]", ""));
    }

    public void submitPayment() {
        getSubmitButton().click();
    }

    public void pay(float sum) {
        setPaySum(sum);
        submitPayment();
    }

    public void payWithVAT(float sum) {
        setPayWithVATSum(sum);
        submitPayment();
    }

    public void payWithCash() {
        getPayWithCashLink().click();
    }

    public int getForecastDaysCount() {
        String days = forecastDaysText.getText().split(" ")[0];
        return Integer.parseInt(days);
    }

    public void checkForecastDays(Matcher<Integer> matcher) {
        Integer days;
        try {
            days = Integer.parseInt(forecastDaysText.getText().split(" ")[0]);
        } catch (Exception e) {
            throw new DirectWebError("Не удалось получить количество прогнозируемых дней из строки " +
                    forecastDaysText.getText());
        }
        assertThat("количество прогнозируемых дней не соответствует ожиданиям.", days, matcher);
    }
}
