package ru.yandex.autotests.direct.web.pages.payment;


import org.hamcrest.Matcher;
import org.openqa.selenium.internal.WrapsElement;

import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;

/**
 * User: buhter
 * Date: 18.03.13
 * Time: 19:27
 * Страница оплаты кампании
 */
@NamedUrls({
        @NamedUrl(name = "payment.page", url = "/registered/main.pl?cmd=pay&cid={1}"),
        @NamedUrl(name = "payment.manager.page", url = "/registered/main.pl?cmd=pay&cid={1}&ulogin={2}")
})
public class PaymentPage extends BasePageObject {
    private PaymentForm paymentForm;

    private PaymentForm onPaymentFormBlock() {
        paymentForm.setConfig(config);
        return paymentForm;
    }

    public void pay(float sum) {
        onPaymentFormBlock().pay(sum);
    }

    public void payWithCash() {
        onPaymentFormBlock().payWithCash();
    }

    public void payWithVAT(Float sum) {
        onPaymentFormBlock().payWithVAT(sum);
    }

    public float getPaymentSum() {
        return onPaymentFormBlock().getPaymentSum();
    }

    public void checkRequiredPaySum(Matcher<WrapsElement> matcher) {
        onPaymentFormBlock().checkRequiredPaySum(matcher);
    }

    public float getPaymentWithVATSum() {
        return onPaymentFormBlock().getPaymentWithVATSum();
    }

    public int getForecastDaysCount() {
        return onPaymentFormBlock().getForecastDaysCount();
    }

    public void checkForecastDays(Matcher<Integer> matcher) {
        onPaymentFormBlock().checkForecastDays(matcher);
    }

    public void setPaySum(float paymentSum) {
        onPaymentFormBlock().setPaySum(paymentSum);
    }

    public void submitPayment() {
        onPaymentFormBlock().submitPayment();
    }
}
