package ru.yandex.autotests.direct.web.pages.payment.yandex.money;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

/**
 * User: buhter
 * Date: 28.06.13
 * Time: 17:57
 */

@FindBy(xpath = "//div[contains(@class, 'domik')]/form")
@Name("Форма логина")
public class LoginForm extends ExtendedHtmlElement {
    @Name("Поле ввода логина")
    @FindBy(xpath = ".//input[@name='login']")
    private TextInput login;

    @Name("Поле ввода пароля")
    @FindBy(xpath = ".//input[@name='passwd']")
    private TextInput password;

    @Name("Кнопка логина")
    @FindBy(xpath = ".//input[@type='submit']")
    private Button loginButton;

    @Name("Кнопка нового логина")
    @FindBy(xpath = ".//button[@type='submit']")
    private Button newLoginButton;

    public TextInput getLogin() {
        return login;
    }

    public TextInput getPassword() {
        return password;
    }

    public Button getLoginButton() {
        return loginButton;
    }

    public Button getNewLoginButton() {
        return newLoginButton;
    }

    public void login(User account) {
        getLogin().getWrappedElement().clear();
        getLogin().getWrappedElement().sendKeys(account.getLogin());
        getPassword().getWrappedElement().clear();
        getPassword().getWrappedElement().sendKeys(account.getPassword());
        getLoginButton().click();
    }

    public void newLogin(User account) {
        getLogin().getWrappedElement().clear();
        getLogin().getWrappedElement().sendKeys(account.getLogin());
        getPassword().getWrappedElement().clear();
        getPassword().getWrappedElement().sendKeys(account.getPassword());
        getNewLoginButton().click();
    }

}

