package ru.yandex.autotests.direct.web.pages.payment.yandex.money;

import java.util.concurrent.TimeUnit;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.hasText;

/**
 * User: buhter
 * Date: 29.06.13
 * Time: 10:17
 */
public class YandexMoneyPage extends BasePageObject {

    @Name("Поле ввода платежного пароля")
    @FindBy(xpath = "//input[@id='passwd']")
    private TextInput paymentPasswordInput;

    @Name("Кнопка подтверждения")
    @FindBy(xpath = "//tr[@id='challenge-submit']//input[@type='submit']")
    private Button acceptButton;

    @Name("Кнопка открытия формы ввода пароля")
    @FindBy(xpath = "//button[contains(@class, 'user__enter')]")
    private Button userEnterButton;

    @Name("Заголовок")
    @FindBy(xpath = "//h1[contains(@class,'title')]")
    private WebElement title;

    LoginForm loginForm;

    public LoginForm onLoginForm(){
        loginForm.setConfig(config);
        return loginForm;
    }

    public TextInput getPaymentPasswordInput() {
        return paymentPasswordInput;
    }

    public Button getAcceptButton() {
        return acceptButton;
    }

    public void shouldSeeTitle(Matcher<String> matcher, long timeoutInSeconds) {
        assertThat("не открылась страница", title,
                should(hasText(matcher))
                        .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(timeoutInSeconds)))
        );
    }

    public void openLoginForm() {
        userEnterButton.click();
    }

    public void accept() {
        getAcceptButton().click();
    }

    public void confirm(String paymentPass) {
        getAcceptButton().click();
        getPaymentPasswordInput().sendKeys(paymentPass);
        getAcceptButton().click();
    }
}
