package ru.yandex.autotests.direct.web.pages.regionselectpopup;

import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@FindBy(xpath = ".//div[contains(@class, 'b-regions-tree__edit-bid-popup-content')]")
@Name("Попап настройки корректировки по гео")
public class GeoCorrectionsPopupBlock extends HtmlElement {

    @Name("Селект выбора увеличить/уменьшить")
    @FindBy(xpath = ".//span[contains(@class, 'b-edit-bid-control__mode ')]")
    private SelectBEM selectBidValue;

    @Name("Инпут корректировки")
    @FindBy(xpath = ".//span[contains(@class, 'b-edit-bid-control__value')]//input")
    private TextInput bidInput;

    @Name("Кнопка 'Ок'")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-region-bid__save')]")
    private Button bidSave;
    
    @Name("Кнопка 'Отмена'")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-region-bid__cancel')]")
    private Button bidCancel;

    public void clickSaveCorrection() {
        bidSave.click();
    }

    public void fillCorrection(GeoCorrectionWeb geoCorrectionWeb) {
        fillSelect(selectBidValue, geoCorrectionWeb.getCpcValue().getValue(), SelectInputMethod.BY_TEXT);
        fillTextInput(bidInput, geoCorrectionWeb.getEnteredValue());
        clickSaveCorrection();
    }
}
