package ru.yandex.autotests.direct.web.pages.representatives.agency;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 09.10.13
 */
@NamedUrls({
        @NamedUrl(name = "show.add.agency.representative.page", url = "/registered/main.pl?cmd=addAgRep")
})
public class AddAgRepPage extends BasePageObject {


    @Name("Логин представителя")
    @FindBy(xpath = ".//input[@name='ag_login']")
    private TextInput representativeLoginInput;

    @Name("Зарегистрировать логин нового представителя")
    @FindBy(xpath = ".//span[contains(@class, 'p-new-agency-representative__passport-link')]")
    private Link registerNewRepresentativeLoginLink;

    @Name("Имя")
    @FindBy(xpath = ".//input[@name='ag_name']")
    private TextInput representativeNameInput;

    @Name("E-mail")
    @FindBy(xpath = ".//input[@name='ag_email']")
    private TextInput representativeEmailInput;

    @Name("Телефон")
    @FindBy(xpath = ".//input[@name='ag_phone']")
    private TextInput representativePhoneInput;

    @Name("Отображать контакты в клиентском интрефейса")
    @FindBy(xpath = ".//input[@name='show_agency_contacts']")
    private CheckBoxBEM showContactsCheckBox;

    @Name("Роль")
    @FindBy(xpath = ".//input[@name='ag_role']")
    private RadioBEM roleRadioButton;

    @Name("Разрешить выставление счетов")
    @FindBy(xpath = ".//input[@name='ag_allow_pay']")
    private CheckBoxBEM allowBillCheckBox;

    @Name("Зарегистрировать")
    @FindBy(xpath = ".//button[@type='submit']")
    private Button registerButton;

    @Name("Подтвердить переход на данную страницу")
    @FindBy(xpath = ".//button[@type='submit' and not(contains(@class, 'p-common-error__cancel'))]")
    private Button submitButton;

    public void clickOnSubmitButton() {
        submitButton.click();
    }

    public void fillRole(String agencyRepresentativeRole) {
        roleRadioButton.selectByValue(agencyRepresentativeRole);
    }

    public void fillRepresentativePersonalData(AccountWeb accountWeb) {
        fillTextInput(representativeLoginInput, accountWeb.getLogin());
        fillTextInput(representativeNameInput, accountWeb.getName());
        fillTextInput(representativeEmailInput, accountWeb.getEmail());
        fillTextInput(representativePhoneInput, accountWeb.getPhone());
        setCheckboxState(showContactsCheckBox, accountWeb.getShowContactsAtClientInterface());
        fillRole(accountWeb.getAgencyRepresentativeRole());
        setCheckboxState(allowBillCheckBox, accountWeb.getAllowBill());
    }

    public void clickOnRegisterButton() {
        registerButton.click();
    }
}
