package ru.yandex.autotests.direct.web.pages.representatives.agency;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.representatives.blocks.AssignClientsOfAgencyTable;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 24.10.13
 */
@NamedUrls({
        @NamedUrl(name = "open.manage.clients.of.agency.page", url = "/registered/main.pl?cmd=manageClientsOfAgency")
})
public class ManageClientsOfAgencyPage extends BasePageObject {


    @Name("Представитель")
    @FindBy(css = "span.p-manage-clients__representatives-select select")
    private SelectBEM representativeSelect;

    @Name("Число клиентов у выбранного представителя")
    @FindBy(css = "div.p-manage-clients__num-clients")
    private WebElement assignedClientsNumber;

    @Name("Чекбокс 'Свободные клиенты'")
    @FindBy(css = "span.p-manage-clients__filter_type_free input")
    private CheckBoxBEM unassignedClientsCheckBox;

    @Name("Чекбокс 'Клиенты выбранного представителя'")
    @FindBy(css = "span.p-manage-clients__filter_type_self input")
    private CheckBoxBEM clientsOfThisRepresentativeCheckBox;

    @Name("Чекбокс 'Клиенты остальных представителей'")
    @FindBy(css = "span.p-manage-clients__filter_type_other input")
    private CheckBoxBEM clientsOfOtherRepresentativesCheckBox;

    @Name("Таблица назначения клиентов представителям")
    @FindBy(css = "div.p-manage-clients__clients")
    private AssignClientsOfAgencyTable assignClientsOfAgencyTable;

    @Name("Сохранить выбор назначения клиентов представителям")
    @FindBy(css = "button.p-manage-clients__save")
    private Button saveButton;

    @Name("Список представителей агентства")
    @FindBy(xpath = ".//a[contains(@href,'cmd=showAgReps')]")
    private Link agencyRepresentativesLink;

    public void selectRepresentative(String representativeUid) {
        representativeSelect.selectByValue(representativeUid);
    }

    public void setUnassignedClientsCheckBox(Boolean state) {
        setCheckboxState(unassignedClientsCheckBox, state);
    }

    public void setClientsOfThisRepresentativeCheckBox(Boolean state) {
        setCheckboxState(clientsOfThisRepresentativeCheckBox, state);
    }

    public void setClientsOfOtherRepresentativesCheckBox(Boolean state) {
        setCheckboxState(clientsOfOtherRepresentativesCheckBox, state);
    }

    public void checkAssignedClientsCount(Matcher matcher) {
        assertThat(assignedClientsNumber.getText(), matcher);
    }

    public void deselectAllVisibleClients() {
        assignClientsOfAgencyTable.deselectAllVisibleClients();
    }

    public void clickOnSaveButton() {
        if (saveButton.isEnabled()) {
            saveButton.click();
        }
    }

    public void setAssignClientCheckBox(String clientLogin, Boolean state) {
        assignClientsOfAgencyTable.setAssignClientCheckBox(clientLogin, state);
    }

    public void shouldSeeClientAssignment(String clientLogin, Matcher matcher) {
        assignClientsOfAgencyTable.shouldSeeClientAssignment(clientLogin, matcher);
    }

    public void clickOnAgencyRepresentativesLink() {
        agencyRepresentativesLink.click();
    }

    private List<String> getVisibleLogins() {
        return assignClientsOfAgencyTable.getVisibleLogins();
    }

    public void checkClientsListLogins(Matcher<List<String>> matcher) {
        assertThat(getVisibleLogins(), matcher);
    }

}
