package ru.yandex.autotests.direct.web.pages.representatives.agency;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.agency.blocks.AgencyRepresentativesTabBlock;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Link;

import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;

/**
 * @autor Alex-samo (alex-samo@yandex-team.ru)
 * Date: 07.10.13
 */
@NamedUrls({
        @NamedUrl(name = "open.show.active.agency.representatives.page", url = "/registered/main.pl?cmd=showAgReps#new"),
        @NamedUrl(name = "open.show.active.agency.representatives.page.for.login",
                url = "/registered/main.pl?cmd=showAgReps&ulogin={1}#new")
})
public class ShowAgRepsPage extends BasePageObject {


    private AgencyRepresentativesTabBlock agencyRepresentativesTabBlock;

    @Name("Действующие представители")
    @FindBy(xpath = ".//li[@id='tabs-tab-0']")
    private Link activeRepresentativesLink;

    @Name("Удаленные представители")
    @FindBy(xpath = ".//li[@id='tabs-tab-1']")
    private Link deleteRepresentativesLink;

    public void clickOnActiveRepresentativesLink() {
        activeRepresentativesLink.click();
    }

    public void clickOnDeletedRepresentativesLink() {
        deleteRepresentativesLink.click();
    }

    public void shouldSeeSeniorRepresentative(AccountWeb accountWeb) {
        agencyRepresentativesTabBlock.shouldSeeSeniorRepresentative(accountWeb);
    }

    public void shouldSeeWorkWithClientsRepresentative(AccountWeb accountWeb) {
        agencyRepresentativesTabBlock.shouldSeeWorkWithClientsRepresentative(accountWeb);
    }

    public void shouldSeeAdministratorRepresentative(AccountWeb accountWeb) {
        agencyRepresentativesTabBlock.shouldSeeAdministratorRepresentative(accountWeb);
    }

    public void shouldSeeDeletedRepresentative(AccountWeb accountWeb) {
        agencyRepresentativesTabBlock.shouldSeeDeletedRepresentative(accountWeb);
    }

    public void addNewRepresentativeLinkClick() {
        agencyRepresentativesTabBlock.addNewRepresentativeLinkClick();
    }

    public void clickOnChangeSeniorRepresentativeLink() {
        agencyRepresentativesTabBlock.clickOnChangeSeniorRepresentativeLink();
    }

    public void editAdministratorRepresentative(String login) {
        agencyRepresentativesTabBlock.editAdministratorRepresentative(login);
    }

    public void editWorkWithClientsRepresentative(String login) {
        agencyRepresentativesTabBlock.editWorkWithClientsRepresentative(login);
    }

    public void deleteAdministratorRepresentative(String login) {
        agencyRepresentativesTabBlock.deleteAdministratorRepresentative(login);
    }

    public void deleteWorkWithClientsRepresentative(String login) {
        agencyRepresentativesTabBlock.deleteWorkWithClientsRepresentative(login);
    }

    public void restoreRepresentative(String login) {
        agencyRepresentativesTabBlock.restoreRepresentative(login);
    }

    public Boolean isAdministratorRepresentativeTable(Matcher matcher) {
        return agencyRepresentativesTabBlock.isAdministratorRepresentativeTable(matcher);
    }

    public Boolean isWorkWithClientsRepresentativeTable(Matcher matcher) {
        return agencyRepresentativesTabBlock.isWorkWithClientsRepresentativeTable(matcher);
    }

    public List<String> getAllAdministratorRepresentativeLogins() {
        if (isAdministratorRepresentativeTable(exists())) {
            return agencyRepresentativesTabBlock.getAllAdministratorRepresentativeLogins();
        } else {
            return null;
        }
    }

    public List<String> getAllWorkWithClientsRepresentativeLogins() {
        if (isWorkWithClientsRepresentativeTable(exists())) {
            return agencyRepresentativesTabBlock.getAllWorkWithClientsRepresentativeLogins();
        } else {
            return null;
        }
    }

    public void clickOnAssignClientsLink() {
        agencyRepresentativesTabBlock.clickOnAssignClientsLink();
    }

    public void clickOnWorkWithClientsRepresentativeLogin(String login) {
        agencyRepresentativesTabBlock.clickOnWorkWithClientsRepresentativeLogin(login);
    }

    public String getSeniorRepresentativeLogin() {
        return agencyRepresentativesTabBlock.getSeniorRepresentativeLogin();
    }
}
