package ru.yandex.autotests.direct.web.pages.representatives.agency;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Select;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 18.10.13
 */
public class SwitchAgChiefPage extends BasePageObject {


    @Name("Новый главный представитель")
    @FindBy(xpath = ".//select[@name='rep_login']")
    private Select newSeniorRepresentativeSelect;

    @Name("Назанчить")
    @FindBy(xpath = ".//input[@name='save']")
    private Button setButton;

    public void selectNewSeniorRepresentative(String login) {
        newSeniorRepresentativeSelect.selectByValue(login);
    }

    public void clickOnSetButton() {
        setButton.click();
    }
}
