package ru.yandex.autotests.direct.web.pages.representatives.agency.blocks;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.blocks.bem.RepresentativesTableBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @autor Alex-samo (alex-samo@yandex-team.ru)
 * Date: 07.10.13
 */
@Name("Блок представителей агенства")
@FindBy(xpath = ".//div[contains(@data-bem, '{\"tabs-panes\"')]")
public class AgencyRepresentativesTabBlock extends HtmlElement {

    @Name("Главный представитель")
    @FindBy(xpath = ".//div[contains(@class, 'p-agency-representatives__representatives-list_type_chief')]/table")
    private RepresentativesTableBEM seniorRepresentativeTable;

    @Name("Представители")
    @FindBy(xpath = ".//div[contains(@class, 'p-agency-representatives__representatives-list_type_main')]/table")
    private RepresentativesTableBEM representativesTable;

    @Name("Представители по работе с клиентами")
    @FindBy(xpath = ".//div[contains(@class, 'p-agency-representatives__representatives-list_type_limited')]/table")
    private RepresentativesTableBEM workWithClientsRepresentativesTable;

    @Name("Удаленные представители")
    @FindBy(xpath = ".//div[contains(@class, 'p-agency-representatives__representatives-list_type_removed')]/table")
    private RepresentativesTableBEM deletedRepresentativesTable;

    @Name("Назначить нового предтавителя")
    @FindBy(xpath = ".//a[contains(@href,'cmd=addAgRep')]")
    private Link addNewRepresentativeLink;

    @Name("Сменить главного предтавителя")
    @FindBy(xpath = ".//a[contains(@href,'cmd=switchAgChief')]")
    private Link changeSeniorRepresentativeLink;

    @Name("Назначение клиентов представителям агентства")
    @FindBy(xpath = ".//a[contains(@href,'cmd=manageClientsOfAgency')]")
    private Link assignClientsLink;

    public void addNewRepresentativeLinkClick() {
        addNewRepresentativeLink.click();
    }

    public void shouldSeeSeniorRepresentative(AccountWeb accountWeb) {
        seniorRepresentativeTable.shouldSeeRepresentativeRow(accountWeb);
    }

    public void shouldSeeAdministratorRepresentative(AccountWeb accountWeb) {
        representativesTable.shouldSeeRepresentativeRow(accountWeb);
    }

    public void shouldSeeWorkWithClientsRepresentative(AccountWeb accountWeb) {
        workWithClientsRepresentativesTable.shouldSeeRepresentativeRow(accountWeb);
    }

    public void shouldSeeDeletedRepresentative(AccountWeb accountWeb) {
        deletedRepresentativesTable.shouldSeeRepresentativeRow(accountWeb);
    }

    public void shouldAdministratorRepresentativeTable(Matcher matcher) {
        assertThat(representativesTable, matcher);
    }

    public void shouldWorkWithClientsRepresentativeTable(Matcher matcher) {
        assertThat(workWithClientsRepresentativesTable, matcher);
    }

    public void editAdministratorRepresentative(String login) {
        representativesTable.editAgencyRepresentative(login);
    }

    public void editWorkWithClientsRepresentative(String login) {
        workWithClientsRepresentativesTable.editAgencyRepresentative(login);
    }

    public void deleteAdministratorRepresentative(String login) {
        representativesTable.deleteAgencyRepresentative(login);
    }

    public void deleteWorkWithClientsRepresentative(String login) {
        workWithClientsRepresentativesTable.deleteAgencyRepresentative(login);
    }

    public void restoreRepresentative(String login) {
        deletedRepresentativesTable.restoreAgencyRepresentative(login);
    }

    public void clickOnChangeSeniorRepresentativeLink() {
        changeSeniorRepresentativeLink.click();
    }

    public Boolean isAdministratorRepresentativeTable(Matcher matcher) {
        return matcher.matches(representativesTable);
    }

    public Boolean isWorkWithClientsRepresentativeTable(Matcher matcher) {
        return matcher.matches(workWithClientsRepresentativesTable);
    }

    public List<String> getAllAdministratorRepresentativeLogins() {
        return representativesTable.getAllRepresentativeLogins();
    }

    public List<String> getAllWorkWithClientsRepresentativeLogins() {
        return workWithClientsRepresentativesTable.getAllRepresentativeLogins();
    }

    public void clickOnAssignClientsLink() {
        assignClientsLink.click();
    }

    public void clickOnWorkWithClientsRepresentativeLogin(String login) {
        workWithClientsRepresentativesTable.clickOnWorkWithClientsRepresentativeLogin(login);
    }

    public String getSeniorRepresentativeLogin() {
        return seniorRepresentativeTable.getAllRepresentativeLogins().get(0);
    }

}
