package ru.yandex.autotests.direct.web.pages.representatives.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 24.10.13
 */

@Name("Список клиентов агентства")
@FindBy(css = "tr.p-manage-clients__client-row_hide_no")
public class AssignClientsOfAgencyRow extends HtmlElement {

    @Name("Назначить клиента представителю")
    @FindBy(css = "span.p-manage-clients__client-checkbox input")
    private CheckBoxBEM assignClientCheckBox;

    @Name("Логин")
    @FindBy(css = "td.p-manage-clients__client-cell_key_login")
    private WebElement login;

    @Name("ФИО")
    @FindBy(css = "td.p-manage-clients__client-cell_key_FIO")
    private WebElement fio;

    @Name("E-mail")
    @FindBy(css = "td.p-manage-clients__client-cell_key_email")
    private Link emailLink;

    @Name("Представитель")
    @FindBy(css = "td.p-manage-clients__client-cell_key_representative")
    private WebElement representative;

    public String getLogin() {
        return login.getText();
    }

    public void setAssignClientCheckBox(Boolean state) {
        setCheckboxState(assignClientCheckBox, state);
    }

    public Boolean getAssignClientCheckBox() {
        return assignClientCheckBox.isSelected();
    }
}
