package ru.yandex.autotests.direct.web.pages.representatives.blocks;


import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static org.hamcrest.MatcherAssert.assertThat;


/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 25.10.13
 */
public class AssignClientsOfAgencyTable extends HtmlElement {

    private List<AssignClientsOfAgencyRow> assignClientsOfAgencyRows;

    private List<AssignClientsOfAgencyRow> getAssignClientsOfAgencyRows() {
        return assignClientsOfAgencyRows;
    }

    /**
     * Возвращает клиента по его логину
     *
     * @param clientLogin - логин клиента
     * @return - Строка представителя, если представителя нет, возвращается null
     */
    private AssignClientsOfAgencyRow getAssignClientsRow(String clientLogin) {
        for (AssignClientsOfAgencyRow client : getAssignClientsOfAgencyRows()) {
            if (client.getLogin().equalsIgnoreCase(clientLogin)) {
                return client;
            }
        }
        return null;
    }

    public void deselectAllVisibleClients() {
        for (AssignClientsOfAgencyRow client : getAssignClientsOfAgencyRows()) {
            client.setAssignClientCheckBox(Boolean.FALSE);
        }
    }

    public void setAssignClientCheckBox(String clientLogin, Boolean state) {
        AssignClientsOfAgencyRow assignClientsOfAgencyRow = getAssignClientsRow(clientLogin);
        if (assignClientsOfAgencyRow == null) {
            throw new DirectWebError("Не найден клиент " + clientLogin);
        } else {
            assignClientsOfAgencyRow.setAssignClientCheckBox(state);
        }
    }

    public void shouldSeeClientAssignment(String clientLogin, Matcher matcher) {
        AssignClientsOfAgencyRow assignClientsOfAgencyRow = getAssignClientsRow(clientLogin);
        if (assignClientsOfAgencyRow == null) {
            throw new DirectWebError("Не найден клиент " + clientLogin);
        } else {
            assertThat(assignClientsOfAgencyRow.getAssignClientCheckBox(), matcher);
        }
    }

    public List<String> getVisibleLogins() {
        List<String> visibleLogins = getAssignClientsOfAgencyRows().stream().filter(client -> client.isDisplayed()).map(AssignClientsOfAgencyRow::getLogin).collect(Collectors.toCollection(() -> new LinkedList<>()));
        return visibleLogins;
    }
}
