package ru.yandex.autotests.direct.web.pages.representatives.blocks;


import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

@Name("Список представителей")
@FindBy(xpath = ".//tr[contains(@class,'b-data-table__row')]")
public class RepresentativeRow extends HtmlElement implements IWebFrom<AccountWeb> {

    @Name("Логин")
    @FindBy(xpath = ".//td[contains(@class,'p-agency-representatives__login-cell')] | .//*[contains(@class,'p-client-reps__table-login')]")
    private WebElement login;

    @Name("ФИО")
    @FindBy(xpath = ".//td[3]")
    private WebElement fio;

    @Name("E-mail")
    @FindBy(xpath = ".//a[contains(@href,'mailto')]")
    private WebElement email;

    @Name("Телефон")
    @FindBy(xpath = ".//td[5]")
    private WebElement phone;

    @Name("Редактировать представителя агентства")
    @FindBy(xpath = ".//a[contains(@href,'cmd=modifyUser')]")
    private Link editAgencyRepresentativeLink;

    @Name("Удалить представителя агентства")
    @FindBy(xpath = ".//a[contains(@href,'cmd=deleteAgRep')]")
    private Link deleteAgencyRepresentativeLink;

    @Name("Восстановить представителя агентства")
    @FindBy(xpath = ".//a[contains(@href,'cmd=addAgRep')]")
    private Link restoreAgencyRepresentativeLink;

    @Name("Редактировать представителя клиента")
    @FindBy(xpath = ".//a[contains(@href,'cmd=userSettings')]")
    private Link editClientRepresentativeLink;

    @Name("Удалить представителя клиента")
    @FindBy(xpath = ".//a[contains(@href,'cmd=deleteClRep')]")
    private Link deleteClientRepresentativeLink;

    @Name("Восстановить представителя клиента")
    @FindBy(xpath = ".//a[contains(@href,'cmd=addClRep')]")
    private Link restoreClientRepresentativeLink;

    public String getLogin() {
        return login.getText();
    }

    public void clickOnWorkWithClientsRepresentativeLoginLink() {
        login.findElement(By.xpath(".//a")).click();
    }

    @Override
    public void fillParameters(AccountWeb accountWeb) {

    }

    @Override
    public void checkParameters(AccountWeb expectedBean) {
        assertThat("параметры представителя соответствуют ожидаемым", getFormFieldsAccording(expectedBean), beanEquals(expectedBean));
    }

    @Override
    public AccountWeb getFormFieldsAccording(AccountWeb expectedBean) {
        AccountWeb accountWeb = inAccordanceWith(expectedBean).forNew(AccountWeb.class)
                .set("login", login, on(WebElement.class).getText())
                .set("name", fio, on(WebElement.class).getText())
                .set("email", email, on(WebElement.class).getText())
                .set("phone", phone, on(WebElement.class).getText())
                .getActualBean();
        return accountWeb;
    }

    public void clickOnEditAgencyRepresentativeLink() {
        editAgencyRepresentativeLink.click();
    }

    public void clickOnDeleteAgencyRepresentativeLink() {
        deleteAgencyRepresentativeLink.click();
    }

    public void clickOnRestoreAgencyRepresentativeLink() {
        restoreAgencyRepresentativeLink.click();
    }

    public void clickOnEditClientRepresentativeLink() {
        editClientRepresentativeLink.click();
    }

    public void clickOnDeleteClientRepresentativeLink() {
        deleteClientRepresentativeLink.click();
    }

    public void clickOnRestoreClientRepresentativeLink() {
        restoreClientRepresentativeLink.click();
    }


}
