package ru.yandex.autotests.direct.web.pages.representatives.blocks.bem;

import java.util.List;
import java.util.stream.Collectors;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.blocks.RepresentativeRow;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 19.08.14
 */
public class RepresentativesTableBEM extends HtmlElement {

    private List<RepresentativeRow> representativesRows;

    /**
     * Возвращает представителя по его логину
     *
     * @param representativeLogin - логин представителя
     * @return - Строка представителя, если представителя нет, возвращается null
     */
    private RepresentativeRow getRepresentativeRow(String representativeLogin) {
        for (RepresentativeRow representative : representativesRows) {
            if (representative.getLogin().equalsIgnoreCase(representativeLogin)) {
                return representative;
            }
        }
        return null;
    }

    public void clickOnWorkWithClientsRepresentativeLogin(String representativeLogin) {
        RepresentativeRow representativeRow = getRepresentativeRow(representativeLogin);
        if (representativeRow == null) {
            throw new DirectWebError("Не найден представитель " + representativeLogin);
        } else {
            representativeRow.clickOnWorkWithClientsRepresentativeLoginLink();
        }
    }

    public void shouldSeeRepresentativeRow(AccountWeb representativeAccountWeb) {
        RepresentativeRow representativeRow = getRepresentativeRow(representativeAccountWeb.getLogin());
        if (representativeRow == null) {
            throw new DirectWebError("Не найден представитель " + representativeAccountWeb.getLogin());
        } else {
            representativeRow.checkParameters(representativeAccountWeb);
        }
    }

    public void editAgencyRepresentative(String login) {
        RepresentativeRow representativeRow = getRepresentativeRow(login);
        if (representativeRow == null) {
            throw new DirectWebError("Не найден представитель " + login);
        } else {
            representativeRow.clickOnEditAgencyRepresentativeLink();

        }
    }

    public void deleteAgencyRepresentative(String login) {
        RepresentativeRow representativeRow = getRepresentativeRow(login);
        if (representativeRow == null) {
            throw new DirectWebError("Не найден представитель " + login);
        } else {
            representativeRow.clickOnDeleteAgencyRepresentativeLink();

        }
    }

    public void restoreAgencyRepresentative(String login) {
        RepresentativeRow representativeRow = getRepresentativeRow(login);
        if (representativeRow == null) {
            throw new DirectWebError("Не найден представитель " + login);
        } else {
            representativeRow.clickOnRestoreAgencyRepresentativeLink();

        }
    }

    public void editClientRepresentative(String login) {
        RepresentativeRow representativeRow = getRepresentativeRow(login);
        if (representativeRow == null) {
            throw new DirectWebError("Не найден представитель " + login);
        } else {
            representativeRow.clickOnEditClientRepresentativeLink();

        }
    }

    public void deleteClientRepresentative(String login) {
        RepresentativeRow representativeRow = getRepresentativeRow(login);
        if (representativeRow == null) {
            throw new DirectWebError("Не найден представитель " + login);
        } else {
            representativeRow.clickOnDeleteClientRepresentativeLink();

        }
    }

    public List<String> getAllRepresentativeLogins() {
        List<String> representativesList = representativesRows.stream().map(RepresentativeRow::getLogin).collect(Collectors.toList());
        return representativesList;
    }

    public void restoreClientRepresentative(String login) {
        RepresentativeRow representativeRow = getRepresentativeRow(login);
        if (representativeRow == null) {
            throw new DirectWebError("Не найден представитель " + login);
        } else {
            representativeRow.clickOnRestoreClientRepresentativeLink();

        }
    }
}
