package ru.yandex.autotests.direct.web.pages.representatives.client;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * @autor Alex-samo (alex-samo@yandex-team.ru)
 * Date: 04.10.13
 */
@NamedUrls({
        @NamedUrl(name = "show.add.client.representative.page", url = "/registered/main.pl?cmd=addClRep")
})
public class AddClRepPage extends BasePageObject {


    @Name("Логин представителя")
    @FindBy(name = "cl_login")
    private TextInput representativeLoginInput;

    @Name("Зарегистрировать логин нового представителя")
    @FindBy(xpath = ".//div[contains(@class, 'p-new-representative__new-login')]/span")
    Link registerNewRepresentativeLoginLink;

    @Name("Имя")
    @FindBy(name="cl_name")
    private TextInput representativeNameInput;

    @Name("E-mail")
    @FindBy(name="cl_email")
    private TextInput representativeEmailInput;

    @Name("Телефон")
    @FindBy(name="cl_phone")
    private TextInput representativePhoneInput;

    @Name("Зарегистрировать")
    @FindBy(xpath = ".//button[@type='submit']")
    private Button registerButton;

    @Name("Подтвердить переход на данную страницу")
    @FindBy(xpath = ".//input[@type='submit']")
    private Button submitButton;

    public void clickOnSubmitButton() {
        submitButton.click();
    }

    public void clickOnRegisterNewRepresentativeLoginLink() {
        registerNewRepresentativeLoginLink.click();
    }

    public void fillRepresentativePersonalData(AccountWeb accountWeb) {
        fillTextInput(representativeLoginInput, accountWeb.getLogin());
        fillTextInput(representativeNameInput, accountWeb.getName());
        fillTextInput(representativeEmailInput, accountWeb.getEmail());
        fillTextInput(representativePhoneInput, accountWeb.getPhone());
    }

    public void clickOnRegisterButton() {
        registerButton.click();
    }
}
