package ru.yandex.autotests.direct.web.pages.representatives.client;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 08.10.13
 */
@NamedUrls({
        @NamedUrl(name = "delete.representative", url = "/registered/main.pl?cmd=deleteClRep&ulogin={1}")
})
public class DeleteClRepPage extends BasePageObject {


    @Name("Продолжить")
    @FindBy(xpath = ".//button[@type='submit' and not(contains(@class, 'p-common-error__cancel'))]")
    private Button submitButton;

    public void clickOnSubmitButton() {
        submitButton.click();
    }
}
