package ru.yandex.autotests.direct.web.pages.representatives.client;

/**
 * Created with IntelliJ IDEA.
 * User: alex-samo
 * Date: 03.10.13
 */

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.client.blocks.ClientRepresentativesTabBlock;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Link;

import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;

@NamedUrls({@NamedUrl(name = "open.show.representatives.page", url = "/registered/main.pl?cmd=showClReps"),
        @NamedUrl(name = "open.show.active.representatives.page.for.login",
                url = "/registered/main.pl?cmd=showClReps&ulogin={1}#new")})
public class ShowClRepsPage extends BasePageObject {


    private ClientRepresentativesTabBlock clientRepresentativesTabBlock;

    @Name("Действующие представители")
    @FindBy(xpath = ".//li[@id='client-reps-tabs-tab-0']")
    private Link activeRepresentativesLink;

    @Name("Удаленные представители")
    @FindBy(xpath = ".//li[@id='client-reps-tabs-tab-1']")
    private Link deleteRepresentativesLink;

    private AlertSteps alert() {
        return AlertSteps.getInstance(AlertSteps.class, config);
    }

    public void clickOnActiveRepresentativesLink() {
        activeRepresentativesLink.click();
    }

    public void clickOnDeletedRepresentativesLink() {
        deleteRepresentativesLink.click();
    }

    public void shouldSeeRepresentative(AccountWeb representativeAccountWeb) {
        clientRepresentativesTabBlock.shouldSeeRepresentative(representativeAccountWeb);
    }

    public void addNewRepresentativeLinkClick() {
        clientRepresentativesTabBlock.addNewRepresentativeLinkClick();
    }

    public void editRepresentative(String login) {
        clientRepresentativesTabBlock.editClientRepresentative(login);
    }

    public void changeSeniorRepresentative() {
        clientRepresentativesTabBlock.clickOnChangeSeniorRepresentativeLink();
    }

    public Boolean isRepresentativeTable(Matcher matcher) {
        return clientRepresentativesTabBlock.isRepresentativeTable(matcher);
    }

    public List<String> getAllRepresentativeLogins() {
        if (isRepresentativeTable(exists())) {
            return clientRepresentativesTabBlock.getAllRepresentativeLogins();
        } else {
            return null;
        }
    }

    public void shouldSeeDeletedRepresentative(AccountWeb accountWeb) {
        clientRepresentativesTabBlock.shouldSeeDeletedRepresentative(accountWeb);
    }

    public void deleteRepresentative(String login) {
        clientRepresentativesTabBlock.deleteRepresentative(login);
    }

    public void restoreRepresentative(String login) {
        clientRepresentativesTabBlock.restoreRepresentative(login);
    }

    public void acceptAlert(Matcher<String> matcher) {
        alert().accept(matcher);
    }

    public String getSeniorRepresentativeLogin() {
        return clientRepresentativesTabBlock.getSeniorRepresentativeLogin();
    }
}
