package ru.yandex.autotests.direct.web.pages.representatives.client;


import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 20.10.13
 */
public class SwitchClChiefPage extends BasePageObject {


    @Name("Новый главный представитель")
    @FindBy(xpath = ".//select[@name='rep_login']")
    private SelectBEM newSeniorRepresentativeSelect;

    @Name("Назанчить")
    @FindBy(xpath = ".//button[contains(@class, 'p-switch-chief__submit')]")
    private Button setButton;

    public void selectNewSeniorRepresentative(String login) {
        newSeniorRepresentativeSelect.selectByValue(login);
    }

    public void clickOnSetButton() {
        setButton.click();
    }
}
