package ru.yandex.autotests.direct.web.pages.representatives.client.blocks;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.blocks.bem.RepresentativesTableBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

@Name("Блок представителей клиента")
@FindBy(xpath = ".//div[contains(@class,'tabs-panes i-bem')]")
public class ClientRepresentativesTabBlock extends HtmlElement {

    @Name("Главный представитель")
    @FindBy(xpath = ".//table[1]")
    private RepresentativesTableBEM seniorRepresentativeTable;

    @Name("Представители")
    @FindBy(xpath = ".//table[2]")
    private RepresentativesTableBEM representativesTable;

    @Name("Удаленные представители")
    @FindBy(css = "div.p-client-reps__old table")
    private RepresentativesTableBEM deletedRepresentativesTable;

    @Name("Назначить нового предтавителя")
    @FindBy(xpath = ".//a[contains(@href,'cmd=addClRep')]")
    private Link addNewRepresentativeLink;

    @Name("Сменить главного представителя")
    @FindBy(xpath = ".//a[contains(@href,'cmd=switchClChief')]")
    private Link changeSenorRepresentativeLink;

    public void addNewRepresentativeLinkClick() {
        addNewRepresentativeLink.click();
    }

    public void shouldSeeRepresentative(AccountWeb representativeAccountWeb) {
        representativesTable.shouldSeeRepresentativeRow(representativeAccountWeb);
    }

    public void editClientRepresentative(String login) {
        representativesTable.editClientRepresentative(login);
    }

    public void clickOnChangeSeniorRepresentativeLink() {
        changeSenorRepresentativeLink.click();
    }

    public Boolean isRepresentativeTable(Matcher matcher) {
        return matcher.matches(representativesTable);
    }

    public List<String> getAllRepresentativeLogins() {
        return representativesTable.getAllRepresentativeLogins();
    }

    public void shouldSeeDeletedRepresentative(AccountWeb accountWeb) {
        deletedRepresentativesTable.shouldSeeRepresentativeRow(accountWeb);
    }

    public void deleteRepresentative(String login) {
        representativesTable.deleteClientRepresentative(login);
    }

    public void restoreRepresentative(String login) {
        deletedRepresentativesTable.restoreClientRepresentative(login);
    }

    public String getSeniorRepresentativeLogin() {
        return seniorRepresentativeTable.getAllRepresentativeLogins().get(0);
    }

}
