package ru.yandex.autotests.direct.web.pages.retargeting.blocks;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.data.retargeting.RetargetingConditionGoalItemWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

@Name("Цель в группе условия ретаргетинга")
@FindBy(xpath = ".//div[contains(@class, 'b-condition-goal')][@onclick]")
public class RetargetingGoalBlock extends HtmlElement implements IWebFrom<RetargetingConditionGoalItemWeb> {
    @Name("Кнопка удаления цели")
    @FindBy(xpath = ".//div[@class = 'b-condition-goal__remove']")
    private WebElement removeGoalButton;

    @Name("Выбор цели")
    @FindBy(xpath = ".//select[@class = 'b-condition-goal__goals']")
    private Select goalSelect;

    @Name("Выбор времени")
    @FindBy(xpath = ".//span[contains(@class, 'b-condition-goal__time-text')]")
    private WebElement goalTimeText;

    @Name("Время цели")
    @FindBy(xpath = ".//input[@class='b-condition-goal__time-hidden']")
    private WebElement goalTimeValue;

    @Name("Поле ввода времени")
    @FindBy(xpath = "//span[contains(@class, 'b-condition-goal-time__input')]//input")
    private TextInput goalTimeInput;

    @Name("Кнопка OK установки времени")
    @FindBy(xpath = "//span[contains(@class, 'b-condition-goal-time__ok')]")
    private Button saveGoalTime;

    @Name("Порядковый номер цели")
    @FindBy(xpath = ".//span[@class = 'b-condition-goal__num']")
    private WebElement goalNumber;

    public void setGoalTime(String goalTime) {
        if (getGoalTime().equals(goalTime))
            return;
        goalTimeText.click();
        fillTextInput(goalTimeInput, goalTime);
        saveGoalTime.click();
    }

    public String getGoalTime() {
        return goalTimeValue.getAttribute("value");
    }

    public String getGoalText() {
        return goalSelect.getFirstSelectedOption().getText();
    }

    public void clickDelete() {
        removeGoalButton.click();
    }

    @Override
    public void fillParameters(RetargetingConditionGoalItemWeb bean) {
        fillSelect(goalSelect, bean.getGoalText(), SelectInputMethod.BY_TEXT);
        setGoalTime(String.valueOf(bean.getTime()));
    }

    @Override
    public void checkParameters(RetargetingConditionGoalItemWeb expectedBean) {
        assertThat("неверные параметры цели", getFormFieldsAccording(expectedBean),
                beanEquals(expectedBean));
    }

    @Override
    public RetargetingConditionGoalItemWeb getFormFieldsAccording(RetargetingConditionGoalItemWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(RetargetingConditionGoalItemWeb.class)
                .set("time", this,
                        on(RetargetingGoalBlock.class).getGoalTime())
                .set("goalText", this,
                        on(RetargetingGoalBlock.class).getGoalText())
                .getActualBean();
    }

    public void checkGoalSelect(Matcher matcher) {
        assertThat("поле не соответствуют ожиданиям", goalSelect, matcher);
    }
}
