package ru.yandex.autotests.direct.web.pages.retargeting.blocks;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.data.retargeting.RetargetingConditionItemWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Select;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Группа в условии ретаргетинга")
@FindBy(xpath = ".//div[contains(@class, 'b-condition-group')][@onclick]")
public class RetargetingGroupBlock extends HtmlElement implements IWebFrom<RetargetingConditionItemWeb> {
    @Name("Список целей")
    private List<RetargetingGoalBlock> goals;

    @Name("Номер группы")
    @FindBy(xpath = ".//span[@class='b-condition-group__group-num']")
    private WebElement groupNum;

    @Name("Выбор условия достижения целей")
    @FindBy(xpath = ".//select[@class = 'b-condition-group__select']")
    private Select goalType;

    @Name("Кнопка удаления группы")
    @FindBy(xpath = ".//div[@class = 'b-condition-group__delete']")
    private WebElement deleteGroupButton;

    @Name("Кнопка добавления цели")
    @FindBy(css = "div.b-condition-goal__add")
    private List<WebElement> addGoalButton;

    private List<RetargetingGoalBlock> getGoals() {
        return goals;
    }

    public String getGoalType() {
        return goalType.getFirstSelectedOption().getAttribute("value");
    }

    public String getGroupNumber() {
        //удаляем не цифры
        return groupNum.getText().replaceAll("[^\\d]", "");
    }

    public WebElement getAddGoalButton() {
        return getVisibleElement(addGoalButton);
    }

    public void clickDelete() {
        deleteGroupButton.click();
    }

    @Override
    public void fillParameters(RetargetingConditionItemWeb bean) {
        fillSelect(goalType, bean.getType(), SelectInputMethod.BY_VALUE);
        //удаляем или добавляем цели
        while (getGoals().size() > bean.getGoals().length) {
            getGoals().get(0).clickDelete();
        }
        while (getGoals().size() < bean.getGoals().length) {
            getAddGoalButton().click();
        }

        //заполняем цели
        for (int i = 0; i < bean.getGoals().length; i++) {
            RetargetingGoalBlock goalBlock = getGoals().get(i);
            goalBlock.fillParameters(bean.getGoals()[i]);
        }
    }

    @Override
    public void checkParameters(RetargetingConditionItemWeb expectedBean) {
        assertThat("неверные параметры группы " + getGroupNumber(), getFormFieldsAccording(expectedBean),
                beanEquals(expectedBean));
        assertThat("неверное количество целей в группе " + getGroupNumber(), goals.size(),
                equalTo(expectedBean.getGoals().length));
        if (goals.size() != expectedBean.getGoals().length)
            return;
        for (int i = 0; i < expectedBean.getGoals().length; i++) {
            RetargetingGoalBlock goalBlock = goals.get(i);
            goalBlock.checkParameters(expectedBean.getGoals()[i]);
        }
    }

    @Override
    public RetargetingConditionItemWeb getFormFieldsAccording(RetargetingConditionItemWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(RetargetingConditionItemWeb.class)
                .set("type", this,
                        on(RetargetingGroupBlock.class).getGoalType())
                .getActualBean();
    }

    public void checkGoalFields(Matcher matcher) {
        assertThat("поле не соответствуют ожиданиям", goalType, matcher);
        for (RetargetingGoalBlock goalBlock : goals) {
            goalBlock.checkGoalSelect(matcher);
        }
    }

}
