package ru.yandex.autotests.direct.web.pages.retargeting.blocks;

import java.util.List;
import java.util.stream.Collectors;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.retargeting.elements.RetargetingPageCheckBox;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Таб сохраненных условий во всплывающем окне ретаргетинга на баннере")
@FindBy(xpath = ".//tr[contains(@class, 'b-retargeting-conditions')]")
public class SavedRetargetingRowBlock extends HtmlElement {
    @Name("Чекбокс выбора условия")
    @FindBy(xpath = ".//div[contains(@class, 'cbx')]//input")
    private RetargetingPageCheckBox rowCheckBox;

    @Name("Номер строки")
    @FindBy(xpath = ".//td[contains(@class, 'tr__num')]")
    private WebElement rowNumber;

    @Name("Имя условия")
    @FindBy(xpath = ".//*[contains(@class, 'tr__name')]")
    private WebElement conditionName;

    @Name("Сайт")
    @FindBy(xpath = ".//div[contains(@class, 'tr__domain')]")
    private WebElement conditionWebSite;

    @Name("Кнопка редактирования условия")
    @FindBy(xpath = ".//td[contains(@class, 'tr__edit')]/img")
    private WebElement editButton;

    @Name("Ссылки на кампании")
    @FindBy(xpath = ".//div[contains(@class, 'tr__campaigns')]/a")
    private List<Link> campaignLinks;

    @Name("Кнопка удаления условия")
    @FindBy(xpath = ".//div[contains(@class, 'tr__del')]")
    private WebElement conditionDeleteButton;

    private List<Link> getCampaignLinks() {
        return campaignLinks;
    }

    public List<String> getCampaignLinksList() {
        List<String> result = getCampaignLinks().stream().map(Link::getReference).collect(Collectors.toList());
        return result;
    }

    public void clickOnName() {
        conditionName.click();
    }

    public void clickDelete() {
        conditionDeleteButton.click();
    }

    public String getConditionNameText() {
        return conditionName.getText();
    }

    public void selectRow() {
        rowCheckBox.select();
    }

    public void clickEdit() {
        editButton.click();
    }
}
