package ru.yandex.autotests.direct.web.pages.retargeting.blocks.bem;

import java.util.List;
import java.util.stream.IntStream;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.on;
import static java.lang.Math.abs;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.httpclient.util.CommonUtils.sleep;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElements;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath.newPath;

@Name("Попап создания нового условия")
@FindBy(xpath = "//div[contains(@class, 'p-retargeting-conditions__edit-popup-content') " +
        "or contains(@class, 'b-retargeting-condition-edit-popup')]")
public class EditConditionPopupBlockBem extends HtmlElement implements IWebFrom<RetargetingConditionWeb> {

    @Name("Название условия")
    @FindBy(xpath = ".//div[contains(@class, 'b-retargeting-condition-edit-name__name')]//input")
    private TextInput conditionName;

    @Name("Показать примечание")
    @FindBy(xpath = ".//span[contains(@class, 'b-retargeting-condition-edit-name__comment-add')]")
    private List<WebElement> addDetailsButton;

    @Name("Скрыть примечание")
    @FindBy(xpath = ".//span[contains(@class, 'b-retargeting-condition-edit-name__comment-remove')]")
    private List<WebElement> removeDetailsButton;

    @Name("Примечание")
    @FindBy(xpath = ".//div[contains(@class, 'b-retargeting-condition-edit-name__comment')]//input")
    private List<TextInput> details;

    @Name("Список групп")
    private List<RetargetingGroupBlockBEM> groups;

    @Name("Кнопки добавления группы")
    @FindBy(xpath = ".//span[contains(@class, 'b-retargeting-condition-edit__create-group-rule')]")
    private List<WebElement> addGroupButtons;

    @Name("Спиннер прогноза посетителей")
    @FindBy(xpath = ".//div[contains(@class,'b-retargeting-condition-edit__forecast-count')]/div[contains(@class, 'spin')]")
    private WebElement visitorForecastSpinner;

    @Name("Кнопка 'Сохранить'")
    @FindBy(xpath = ".//button[(contains(@class, 'b-retargeting-condition-edit-popup__footer-but-save') "
            + "or contains(@class, 'button_action_apply')) and not(contains(@class, 'save-as'))]")
    private WebElement saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(xpath = ".//button[contains(@class, 'b-retargeting-condition-edit-popup__footer-but-cancel') or contains(@class, 'button_action_decline')]")
    private WebElement cancelButton;

    @Name("Кнопка сохранить как новое")
    @FindBy(xpath = ".//button[contains(@class, 'save-as')]")
    private List<Button> saveAsNewButton;

    @Name("Текст ошибки, появляющейся при некорректном сохранении условия")
    @FindBy(xpath = ".//div[@class = 'b-error-pretty-message__text']")
    private WebElement errorInPopup;

    @Override
    public void fillParameters(RetargetingConditionWeb bean) {
        fillTextInput(getConditionNameElement(), bean.getRetargetingConditionName());
        if (bean.getRetargetingConditionDescription() != null) {
            if (getVisibleElements(addDetailsButton).size() > 0) {
                getAddDetailsButton().click();
            }
            fillTextInput(getDetailsElement(), bean.getRetargetingConditionDescription());
        }

        if (bean.getRetargetingConditionItemsWeb() != null) {
            //удаляем или добавляем группы
            boolean shouldDelete = getGroups().size() > bean.getRetargetingConditionItemsWeb().length;
            for (int diff = abs(getGroups().size() - bean.getRetargetingConditionItemsWeb().length); diff > 0; diff--) {
                if (shouldDelete) {
                    getGroups().get(0).clickDelete();
                } else {
                    WebElement addGroupButton = getVisibleElement(addGroupButtons);
                    if (addGroupButton != null) {
                        addGroupButton.click();
                    }
                }
            }
            sleep(1000);
            //заполняем группы
            for (int i = 0; i < bean.getRetargetingConditionItemsWeb().length; i++) {
                RetargetingGroupBlockBEM groupBlock = getRetargetingGroupBlock(i);
                groupBlock.fillParameters(bean.getRetargetingConditionItemsWeb()[i]);
            }
        }
        waitForElement(visitorForecastSpinner, 3, not(WebElementMatchers.isDisplayed()));
    }

    @Override
    public void checkParameters(RetargetingConditionWeb expectedBean) {
        sleep(1000);
        assertThat("параметры условия ретаргетинга соответствуют ожидаемым", getFormFieldsAccording(
                expectedBean),
                beanDiffer(expectedBean).useCompareStrategy(
                        DefaultCompareStrategies.allFieldsExcept(newPath("bannerId"), newPath("adGroupId"),
                                newPath("retargetingConditionItemsWeb"))));
        if (expectedBean.getRetargetingConditionItemsWeb() != null) {
            assertThat("количество групп условия соответствует ожидаемому", getGroups(),
                    hasSize(expectedBean.getRetargetingConditionItemsWeb().length));
            for (int i = 0; i < expectedBean.getRetargetingConditionItemsWeb().length; i++) {
                RetargetingGroupBlockBEM groupBlock = getRetargetingGroupBlock(i);
                groupBlock.checkParameters(expectedBean.getRetargetingConditionItemsWeb()[i]);
            }
        }
    }

    @Override
    public RetargetingConditionWeb getFormFieldsAccording(RetargetingConditionWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(RetargetingConditionWeb.class)
                .set("retargetingConditionName", this,
                        on(EditConditionPopupBlockBem.class).getName())
                .set("retargetingConditionDescription", this,
                        on(EditConditionPopupBlockBem.class).getDetails())
                .getActualBean();
    }

    public void checkRetargetingPopupFields(RetargetingConditionWeb expectedBean, Matcher matcher) {
        assertThat("поле не соответствуют ожиданиям", getConditionNameElement(), matcher);
        assertThat("поле не соответствуют ожиданиям", getDetailsElement(), matcher);
        IntStream i = IntStream.range(1, expectedBean.getRetargetingConditionItemsWeb().length + 1);
        i.forEach(value -> getRetargetingGroupBlock(value).checkGoalFields(matcher));
    }

    public void checkErrorInPopup(String errorText) {
        assertThat("текст ошибки соответствует ожидаемому", errorInPopup.getText(), is(errorText));
    }

    public void clickSave() {
        getSaveButton().click();
    }

    public void clickCancel() {
        getCancelButton().click();
    }

    public void clickSaveAsNew() {
        getSaveAsNewButton().click();
    }

    public String getName() {
        return getConditionNameElement().getText();
    }

    public String getDetails() {
        return getDetailsElement().getText();
    }


    private TextInput getConditionNameElement() {
        return conditionName;
    }

    private WebElement getAddDetailsButton() {
        return getVisibleElement(addDetailsButton);
    }

    private WebElement getRemoveDetailsButton() {
        return getVisibleElement(removeDetailsButton);
    }

    private Button getSaveAsNewButton() {
        return getVisibleElement(saveAsNewButton);
    }

    private TextInput getDetailsElement() {
        return getVisibleElement(details);
    }

    private List<RetargetingGroupBlockBEM> getGroups() {
        return groups;
    }


    private WebElement getSaveButton() {
        return saveButton;
    }

    private WebElement getCancelButton() {
        return cancelButton;
    }

    private RetargetingGroupBlockBEM getRetargetingGroupBlock(int groupNumber) {
        return getGroups().get(groupNumber);
    }
}
