package ru.yandex.autotests.direct.web.pages.retargeting.blocks.bem;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.data.retargeting.RetargetingConditionGoalItemWeb;
import ru.yandex.autotests.direct.web.data.retargeting.RetargetingConditionItemWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.RetargetingRadioBlockBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ch.lambdaj.Lambda.on;
import static java.lang.Math.abs;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.httpclient.util.CommonUtils.sleep;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Группа в условии ретаргетинга")
@FindBy(xpath = ".//div[contains(@class, 'b-retargeting-condition-edit-group-rule__body')]")
public class RetargetingGroupBlockBEM extends HtmlElement implements IWebFrom<RetargetingConditionItemWeb> {
    @Name("Список целей")
    private List<RetargetingGoalBlockBEM> goals;

    @Name("Выбор условия достижения целей")
    @FindBy(xpath = ".//span[contains(@class, 'radio-button')]")
    private RetargetingRadioBlockBEM goalType;

    @Name("Кнопка удаления группы")
    @FindBy(xpath = ".//span[contains(@class , 'group-rule-remove')]")
    private WebElement deleteGroupButton;

    @Name("Кнопка добавления цели")
    @FindBy(xpath = ".//span[contains(@class, 'group-rule__create-rule')]")
    private List<WebElement> addGoalButton;

    private List<RetargetingGoalBlockBEM> getGoals() {
        return goals;
    }

    public String getGoalType() {
        return goalType.getSelectedButton().getAttribute("value");
    }

    public WebElement getAddGoalButton() {
        return getVisibleElement(addGoalButton);
    }

    public void clickDelete() {
        deleteGroupButton.click();
    }

    @Override
    public void fillParameters(RetargetingConditionItemWeb bean) {
        fillRadio(goalType, bean.getType().toUpperCase(), RadioInputMethod.BY_VALUE);
        //удаляем или добавляем цели
        boolean shouldDelete = getGoals().size() > bean.getGoals().length;
        for (int diff = abs(getGoals().size() - bean.getGoals().length); diff > 0; diff--) {
            if (shouldDelete) {
                getGoals().get(0).clickDelete();
            } else {
                getAddGoalButton().click();
            }
        }
        sleep(1000);

        //заполняем цели
        for (int i = 0; i < bean.getGoals().length; i++) {
            RetargetingGoalBlockBEM goalBlock = getGoals().get(i);
            goalBlock.fillParameters(bean.getGoals()[i]);
        }
    }

    @Override
    public void checkParameters(RetargetingConditionItemWeb expectedBean) {
        assertThat("неверные параметры группы ", getFormFieldsAccording(expectedBean),
                beanEquals(expectedBean));
        assertThat("неверное количество целей в группе ", goals.size(),
                equalTo(expectedBean.getGoals().length));
        if (goals.size() != expectedBean.getGoals().length) {
            return;
        }
        for (int i = 0; i < expectedBean.getGoals().length; i++) {
            RetargetingGoalBlockBEM goalBlock = goals.get(i);
            goalBlock.checkParameters(expectedBean.getGoals()[i]);
        }
    }

    @Override
    public RetargetingConditionItemWeb getFormFieldsAccording(RetargetingConditionItemWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(RetargetingConditionItemWeb.class)
                .set("type", this,
                        on(RetargetingGroupBlockBEM.class).getGoalType())
                .getActualBean();
    }

    public void checkGoalFields(Matcher matcher) {
        assertThat("поле не соответствуют ожиданиям", goalType, matcher);
        for (RetargetingGoalBlockBEM goalBlock : goals) {
            goalBlock.checkGoalSelect(matcher);
        }
    }

    public RetargetingConditionItemWeb getRetargetingConditionItemWeb() {
        RetargetingConditionItemWeb result = new RetargetingConditionItemWeb();
        result.setType(getGoalType());
        result.setGoals(goals.stream().map(RetargetingGoalBlockBEM::getRetargetingConditionGoalItemWeb).toArray(
                RetargetingConditionGoalItemWeb[]::new));
        return result;
    }
}
