package ru.yandex.autotests.direct.web.pages.retargeting.blocks.bem;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Попап условия ретаргетинга")
@FindBy(xpath = "//div[contains(@class, 'b-edit-retargeting_js_inited')]")
public class RetargetingPopupBlockBEM extends HtmlElement {

    private List<SavedRetargetingRowBlockBEM> savedRetargetingRowList;

    @Name("Кнопка 'Добавить набор правил'")
    @FindBy(xpath = ".//div[contains(@class, 'b-retargeting-conditions-list__add')]")
    private WebElement addRulesButton;

    @Name("Кнопка 'Сохранить'")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-retargeting__save')]")
    private WebElement saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-retargeting__cancel')]")
    private WebElement cancelButton;


    public void checkSavedRetargetingCondition(String conditionName) {
        SavedRetargetingRowBlockBEM SavedRetargetingRowBlock = getSavedRetargetingRowBlock(conditionName);
        if (SavedRetargetingRowBlock == null) {
            throw new DirectWebError("Не найдено условие " + conditionName);
        } else {
            SavedRetargetingRowBlock.selectRow();
        }
    }

    public void clickEditSavedRetargetingCondition(String conditionName) {
        SavedRetargetingRowBlockBEM SavedRetargetingRowBlock = getSavedRetargetingRowBlock(conditionName);
        if (SavedRetargetingRowBlock == null) {
            throw new DirectWebError("Не найдено условие " + conditionName);
        } else {
            SavedRetargetingRowBlock.clickEdit();
        }
    }

    public void clickAddRulesButton() {
        addRulesButton.click();
    }

    public void clickSave() {
        saveButton.click();
    }

    public void clickCancel() {
        cancelButton.click();
    }

    private List<SavedRetargetingRowBlockBEM> getSavedRetargetingRowList() {
        return savedRetargetingRowList;
    }

    private SavedRetargetingRowBlockBEM getSavedRetargetingRowBlock(String conditionName) {
        for (SavedRetargetingRowBlockBEM SavedRetargetingRowBlock : getSavedRetargetingRowList()) {
            if (SavedRetargetingRowBlock.getConditionNameText().equals(conditionName)) {
                return SavedRetargetingRowBlock;
            }
        }
        return null;
    }

}
