package ru.yandex.autotests.direct.web.pages.retargeting.blocks.bem;

import java.util.List;
import java.util.stream.Collectors;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

@Name("Сохраненное условие подбора аудиторий")
@FindBy(xpath = "//tr[contains(@class, 'p-retargeting-conditions__condition-row')]")
public class SavedConditionPageRowBem extends HtmlElement {
    @Name("Чекбокс выбора условия")
    @FindBy(xpath = ".//span[contains(@class, 'p-retargeting-conditions__condition-checkbox')]//input")
    private CheckBoxBEM rowCheckBox;

    @Name("Номер строки")
    @FindBy(xpath = ".//td[contains(@class, 'p-retargeting-conditions__condition-cell_key_name')]")
    private WebElement rowNumber;

    @Name("Имя условия")
    @FindBy(xpath = ".//td[3]//span[contains(@class, 'b-group-retargeting-condition__model-field')]")
    private WebElement conditionName;

    @Name("Имя условия")
    @FindBy(xpath = ".//span[contains(@class, 'b-group-retargeting-condition__remove')]")
    private WebElement deleteCondition;

    @Name("Сайт")
    @FindBy(xpath = ".//td[contains(@class, 'p-retargeting-conditions__condition-cell_key_domains')]")
    private WebElement conditionWebSite;

    @Name("Ссылки на кампании")
    @FindBy(xpath = ".//div[contains(@class, 'p-retargeting-conditions__campaign')]/a")
    private List<Link> campaignLinks;

    @Name("Условие может работать неправильно")
    @FindBy(xpath = ".//span[contains(@class, 'p-retargeting-conditions__warning')]/span")
    private WebElement wrongWorkingCondition;

    @Name("Еще кампании")
    @FindBy(xpath = ".//td[contains(@class, 'p-retargeting-conditions__condition-cell_key_campaigns')]" +
            "//span[contains(@class, 'link__inner')]")
    private WebElement anotherCamps;

    public List<String> getCampaignLinksList() {
        List<String> result = campaignLinks.stream().map(Link::getReference).collect(Collectors.toList());
        return result;
    }

    public String getConditionNameText() {
        return conditionName.getText();
    }

    public void clickOnNameLink() {
        conditionName.click();
    }

    public void clickDelete() {
        deleteCondition.click();
    }

    public void openWrongWorkingCondition() {
        wrongWorkingCondition.click();
    }


    public void showAnotherCamps() {
        anotherCamps.click();
    }
}
