package ru.yandex.autotests.direct.web.pages.retargeting.blocks.bem;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Сохраненные условия во всплывающем окне ретаргетинга на баннере")
@FindBy(xpath = ".//div[contains(@class, 'b-retargeting-conditions-list-item_js_inited')]")
public class SavedRetargetingRowBlockBEM extends HtmlElement {

    @Name("Чекбокс выбора условия")
    @FindBy(xpath = ".//span[contains(@class, 'retargeting-conditions')]//input")
    private CheckBoxBEM rowCheckBox;

    @Name("Номер строки")
    @FindBy(xpath = ".//div[contains(@class, 'b-retargeting-conditions-list-item__index')]")
    private WebElement rowNumber;

    @Name("Имя условия")
    @FindBy(xpath = ".//div[contains(@class, 'b-retargeting-conditions-list-item__name')]")
    private WebElement conditionName;

    @Name("Ссылка 'имя условия' на странице условий ретаргетинга")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-retargeting-condition__name.link')]")
    private WebElement conditionNameLink;

    @Name("Сайт")
    @FindBy(xpath = ".//div[contains(@class, 'b-retargeting-conditions-list-item__site')]")
    private WebElement conditionWebSite;

    @Name("Кнопка редактирования условия")
    @FindBy(xpath = ".//button[contains(@class, 'b-retargeting-conditions-list-item__edit')]")
    private WebElement editButton;

    @Name("Кнопка удаления условия")
    @FindBy(xpath = ".//button[contains(@class, 'b-retargeting-conditions-list-item__delete')]" +
            "span[contains(@class,'b-group-retargeting-condition__remove')]")
    private WebElement conditionDeleteButton;

    public void clickOnNameLink() {
        conditionNameLink.click();
    }

    public String getConditionNameText() {
        return conditionName.getText();
    }

    public void selectRow() {
        rowCheckBox.select();
    }

    public void clickEdit() {
        editButton.click();
    }

    public void clickDelete() {
        conditionDeleteButton.click();
    }

}
