package ru.yandex.autotests.direct.web.pages.retargeting.elements;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.qatools.htmlelements.element.CheckBox;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class RetargetingPageCheckBox extends CheckBox {
    /**
     * Specifies wrapped {@link org.openqa.selenium.WebElement}.
     *
     * @param wrappedElement {@code WebElement} to wrap.
     */
    public RetargetingPageCheckBox(WebElement wrappedElement) {
        super(wrappedElement);
    }

    @Override
    public boolean isSelected() {
        WebElement parentTR = getWrappedElement().findElement(
                By.xpath(".."));
        Pattern pattern = Pattern.compile("checkbox_checked_(yes|no)");
        Matcher matcher = pattern.matcher(parentTR.getAttribute("class"));
        return matcher.find() && matcher.group().contains("yes");
    }

    @Override
    public void deselect() {
        if (isSelected()) {
            getWrappedElement().click();
        }
    }

    @Override
    public void select() {
        if (!isSelected()) {
            getWrappedElement().click();
        }
    }
}
