package ru.yandex.autotests.direct.web.pages.showcamp.blocks;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.contactinfo.Regions;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Name("Список блоков предпросмотра баннера")
@FindBy(xpath = ".//div[contains(@class, 'b-banner-list__layout__frame')]")
public class BannerPreviewBlock extends ExtendedHtmlElement {
    @Name("ID баннера")
    @FindBy(xpath = ".//a[@name]")
    private WebElement bannerID;

    @Name("Чекбокс для выбора баннера")
    @FindBy(xpath = ".//input[@name = 'bid_multi']")
    private CheckBox selectBannerCheckBox;

    @Name("Ссылка редактировать для баннера")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=showCampMultiEdit')]")
    private Link editBannerLink;

    @Name("Ссылка копировать для баннера")
    @FindBy(xpath = ".//a[contains(@href, 'is_copy=1')]")
    private Link copyBannerLink;

    @Name("Ссылка редактировать для баннера")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=stopBanner')]")
    private Link stopBannerLink;

    @Name("Ссылка возобновить для баннера")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=resumeBanner')]")
    private Link activateBannerLink;

    @Name("Кнопка открывающая попап изменения минус слов")
    @FindBy(xpath = ".//span[contains(@class, 'b-minus-words-link__switcher')]")
    private Link editMinusKeywordsLink;

    @Name("Ссылка редактировать для медиаплана")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=multieditMediaplan')]")
    private WebElement editMediaplanLink;

    @Name("Ссылка копировать для медиаплана")
    @FindBy(xpath = ".//a[contains(@href, 'current_action=copy')]")
    private WebElement copyMediaplanLink;

    @Name("Ссылка удалить")
    @FindBy(xpath = ".//a[contains(@onclick, 'return confirm')]")
    private WebElement deleteLink;

    @Name("Чекбокс для мультиредактирования")
    @FindBy(xpath = ".//input[@name = 'bid_multi']")
    private CheckBox multiEditCheckBox;

    @Name("Номер объявления/медиаплана")
    @FindBy(xpath = ".//div[./label[contains(@class, 'banner__label')]]")
    private WebElement bannerNumber;

    @Name("Ссылка открывающая попап с быстрыми ссылками для объявления")
    @FindBy(xpath = ".//span[contains(@class, 'preview__addition-link_for_sitelinks')]")
    private Link siteLinks;

    @Name("Заголовок баннера")
    @FindBy(xpath = ".//a[contains(@class, '__title-link')]")
    private Link bannerTitle;

    @Name("Текст баннера")
    @FindBy(xpath = ".//p[contains(@class, 'preview__body')]")
    private WebElement bannerBody;

    @Name("Домен")
    @FindBy(xpath = ".//span[contains(@class, 'preview__domain-text')]")
    private WebElement bannerDomain;

    @Name("Регионы показа")
    @FindBy(xpath = ".//div[contains(@class, 'preview__geo')]")
    private WebElement bannerGeo;

    @Name("")
    @FindBy(xpath = ".//span[contains(@class, '__banner_id')]")
    private WebElement bannerIDonEditPage;

    @Name("Кнопка открытия попапа меток банера")
    @FindBy(xpath = ".//div[@class='b-tag__i']")
    private WebElement openTagsPopupButton;

    @Name("Список меток")
    @FindBy(xpath = ".//span[contains(@class, 'b-banner-tags__tags-link-list')]/a")
    private List<Link> tagLinks;

    @Name("Id баннера в блоке медиаплана")
    @FindBy(css = "div.b-banner-list__layout__header")
    private WebElement bannerIdInMediaplanBlock;

    private boolean isEditPage = false;

    public static class SiteLinksPopup extends HtmlElement {

        @Name("Список ссылок")
        @FindBy(xpath = ".//a[contains(@class, 'preview__sitelink')]")
        private List<Link> siteLinks;

        public void checkParameters(SiteLinkInfoWeb[] expectedBean) {
            SiteLinkInfoWeb[] actualBean = getFormFieldsAccording(expectedBean);
            for (int i = 0; i < expectedBean.length; i++) {
                assertThat("быстрые ссылки не соответствует ожиданиям", expectedBean[i], beanEquals(actualBean[i]));
            }
        }

        public SiteLinkInfoWeb[] getFormFieldsAccording(SiteLinkInfoWeb[] expectedBean) {
            List<SiteLinkInfoWeb> sitelinks = new ArrayList<>();
            for (Link siteLink : this.siteLinks) {
                String href = siteLink.getReference().replaceAll("http://", "").replace("/", "");
                String title = siteLink.getText();
                sitelinks.add(new SiteLinkInfoWeb(title, href));
            }
            return sitelinks.toArray(new SiteLinkInfoWeb[sitelinks.size()]);
        }
    }

    public static class MinusKeywordsPopup extends ExtendedHtmlElement {

        @Name("Минус слова")
        @FindBy(xpath = ".//textarea[contains(@class, 'b-minus-words-popup__minus-words')]")
        private TextInput minusKeywords;

        @Name("Кнопка сохранить")
        @FindBy(xpath = ".//span[contains(@class, 'b-minus-words-popup__ok')]")
        private Button saveButton;

        @Name("Кнопка отменить")
        @FindBy(xpath = ".//span[contains(@class, 'b-minus-words-popup__cancel')]")
        private Button cancelButton;

        public void fillMinusKeywordsAndSave(String keywords) {
            minusKeywords.clear();
            minusKeywords.sendKeys(keywords);
            takeScreenshot();
            saveButton.click();
        }
    }

    @FindBy(xpath = "//div[contains(@class, 'popup_for_sitelinks')]")
    private SiteLinksPopup siteLinksPopup;

    @FindBy(xpath = "//div[contains(@class, 'b-minus-words-popup__content')]")
    private MinusKeywordsPopup minusKeywordsPopup;

    public MinusKeywordsPopup getMinusKeywordsPopup() {
        minusKeywordsPopup.setConfig(config);
        return minusKeywordsPopup;
    }

    public void setIsEditPage(boolean isEditPage) {
        this.isEditPage = isEditPage;
    }

    public Long getBannerId() {
        if (isEditPage) {
            return Long.parseLong(bannerIDonEditPage.getText().split("-")[1]);
        } else {
            return Long.parseLong(bannerID.getAttribute("name"));
        }
    }

    public void clickEditMediaplan() {
        editMediaplanLink.click();
    }

    public void clickCopyMediaplan() {
        copyMediaplanLink.click();
    }

    public void selectMultiEditCheckBox() {
        multiEditCheckBox.select();
    }

    public void clickEditBanner() {
        editBannerLink.click();
    }

    public void clickCopyBanner() {
        copyBannerLink.click();
    }

    public void clickStopBanner() {
        stopBannerLink.click();
    }

    public void clickActivateBanner() {
        activateBannerLink.click();
    }

    public void selectBannerCheckBox() {
        selectBannerCheckBox.select();
    }

    public void checkBannerNumber(Matcher matcher) {
        assertThat("номер объявления/медиаплана не соответствует ожиданиям.",
                bannerNumber, matcher);
    }

    public CheckBox getSelectBannerCheckBox() {
        return selectBannerCheckBox;
    }

    public Link getEditBannerLink() {
        return editBannerLink;
    }

    public CheckBox getMultiEditCheckBox() {
        return multiEditCheckBox;
    }

    public void checkSiteLinks(SiteLinkInfoWeb[] expectedSitelink) {
        if (expectedSitelink != null) {
            siteLinks.click();
            siteLinksPopup.checkParameters(expectedSitelink);
        }
    }

    public void checkTags(List<String> tags) {
        if (tags != null) {
            assertThat(extract(tagLinks, on(Link.class).getText()), containsInAnyOrder(tags.toArray()));
        }
    }

    public void checkParameters(BannerInfoWeb expectedBean) {
        assertThat("неверные параметры баннера ", getFormFieldsAccording(expectedBean),
                beanEquals(expectedBean));
        checkSiteLinks(expectedBean.getSitelinks());
        checkTags(expectedBean.getTags());
    }

    public String getRegionsIDs() {
        String regions = bannerGeo.getText().split(": ")[1]; //избавляемся от фразы "Регионы показа:"

        List<String> regionsText = Arrays.asList(regions.split(", "));
        List<String> regionsIDs = regionsText.stream().map(regionText -> Regions.getRegion(regionText).getRegionID())
                .collect(Collectors.toList());

        return StringUtils.join(regionsIDs, ",");
    }

    public BannerInfoWeb getFormFieldsAccording(BannerInfoWeb expectedBean) {
        BannerInfoWeb actualBean = inAccordanceWith(expectedBean).forNew(BannerInfoWeb.class)
                .set("title", bannerTitle, on(Link.class).getText())
                .set("text", bannerBody, on(WebElement.class).getText())
                .set("domain", bannerDomain, on(WebElement.class).getText())
                .set("geo", this, on(BannerPreviewBlock.class).getRegionsIDs())
                .getActualBean();
        actualBean.setBannerId(getBannerId());
        actualBean.setCampaignId(expectedBean.getCampaignId());
        return actualBean;
    }

    public void checkEditBannerLink(Matcher matcher) {
        assertThat(editBannerLink, matcher);
    }

    public void fillMinusKeywordsAndSave(String keywords) {
        editMinusKeywordsLink.click();
        takeScreenshot();
        getMinusKeywordsPopup().fillMinusKeywordsAndSave(keywords);
    }

    public void deleteBanner() {
        deleteLink.click();
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    public void clickOnOpenTagsPopupButton() {
        openTagsPopupButton.click();
    }

    public boolean hasBannerIdAsMediaplanBlock(Long bannerId) {
        return bannerIdInMediaplanBlock.getText().contains(String.valueOf(bannerId));
    }

}
