package ru.yandex.autotests.direct.web.pages.showcamp.blocks;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * User: xy6er
 * Date: 10.09.13
 * Time: 18:00
 */

@Name("Вкладки баннеров")
public class BannerTab extends HtmlElement {

    @Name("Ссылка таба")
    @FindBy(css = "a.b-menu__item__link")
    private Link tabLink;

    @Name("Количество объявлений")
    @FindBy(css = "span.b-menu__item__count")
    private WebElement bannersCount;

    @Override
    public void click() {
        tabLink.click();
    }

    public String getTitle() {
        return getWrappedElement().getText().replaceAll("\\d", "").trim();
    }

    public void checkBannersCount(Matcher matcher) {
        assertThat(bannersCount, matcher);
    }
}
