package ru.yandex.autotests.direct.web.pages.showcamp.blocks;

import java.util.List;
import java.util.Map;

import org.hamcrest.Matcher;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.banners.BannerTabsEnum;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * User: xy6er
 * Date: 09.09.13
 * Time: 17:47
 */

@Name("Панель вкладок объявлений")
@FindBy(css = "tr.b-campinfo__tabs")
public class BannerTabsPanel extends HtmlElement {

    @Name("Список вкладок")
    @FindBy(css = "div.b-menu__item")
    private List<BannerTab> tabsList;

    private List<BannerTab> getTabsList() {
        return tabsList;
    }

    private Map<BannerTabsEnum, BannerTab> tabsMap = null;

    private BannerTab getBannerTab(BannerTabsEnum tab) {
        String tabName = tab.getName();
        for (BannerTab bannerTab : getTabsList()) {
            if (tabName.equals(bannerTab.getTitle())) {
                return bannerTab;
            }
        }
        return null;
    }

    public void clickOnBannerTab(BannerTabsEnum tab) {
        BannerTab bannerTab = getBannerTab(tab);
        if (bannerTab == null) {
            throw new DirectWebError("Таб не найден " + tab.getName());
        } else {
            bannerTab.click();
        }
    }

    public void checkBannerTab(BannerTabsEnum tab, Matcher matcher) {
        BannerTab bannerTab = getBannerTab(tab);
        if (bannerTab == null) {
            throw new DirectWebError("Таб не найден " + tab.getName());
        } else {
            assertThat(bannerTab, matcher);
        }
    }

    public void checkBannersTabCount(BannerTabsEnum tab, Matcher matcher) {
        BannerTab bannerTab = getBannerTab(tab);
        if (bannerTab == null) {
            throw new DirectWebError("Таб не найден " + tab.getName());
        } else {
            bannerTab.checkBannersCount(matcher);
        }
    }
}