package ru.yandex.autotests.direct.web.pages.showcampbem;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.banners.BannerActionsEnum;
import ru.yandex.autotests.direct.web.data.banners.BannerTabsEnum;
import ru.yandex.autotests.direct.web.data.banners.MinusKeyWordsTypes;
import ru.yandex.autotests.direct.web.data.mediaplan.CopyBannerParameters;
import ru.yandex.autotests.direct.web.data.priceconstructor.BannerPhrasePlatform;
import ru.yandex.autotests.direct.web.data.priceconstructor.ConstructorMode;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.GroupMultiplierStatsWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.HelpRequestInfo;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.DynamicFeedFilter;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.FeedFilterBase;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.PerformanceFeedFilter;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.campaigns.strategy.IStrategyBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.strategy.IStrategyBlockProvider;
import ru.yandex.autotests.direct.web.pages.group.dynamictext.EditDynamicFilterBlock;
import ru.yandex.autotests.direct.web.pages.group.performance.EditPerformanceFilterBlock;
import ru.yandex.autotests.direct.web.pages.priceconstructor.IPriceConstructorProvider;
import ru.yandex.autotests.direct.web.pages.priceconstructor.PriceConstructorBem;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.*;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.AutoCorrectionPopupBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.BannerGroupPreviewPopupBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.BannerListTabs;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.BannersSearchBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases.BannerPhrasesBlockBEM;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategyBemBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategyBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategyWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

import static com.google.common.collect.Iterables.getLast;
import static java.lang.String.format;
import static java.util.Objects.isNull;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.samePropertyValuesAs;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.matchers.IgnoreWhiteSpaceDiffStringMatcherWrapper.equalToIgnoringWhiteSpaceDiff;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isEnabled;
import static ru.yandex.qatools.matchers.collection.HasSameItemsAsCollectionMatcher.hasSameItemsAsCollection;

@NamedUrls({
        @NamedUrl(name = "show.camp", url = "/registered/main.pl?cmd=showCamp&cid={1}"),
        @NamedUrl(name = "show.camp.for.login", url = "/registered/main.pl?cmd=showCamp&cid={1}&ulogin={2}"),
        @NamedUrl(name = "show.camp.page.for.super",
                url = "/registered/main.pl?cmd=showCamp&cid={1}&ulogin={2}&optimizeCamp=1"),
        @NamedUrl(name = "show.camp.page.filter", url = "/registered/main.pl?cmd=showCamp&tab={1}&cid={2}&ulogin={3}"),
        @NamedUrl(name = "show.camp.page.search",
                url = "/registered/main.pl?cmd=showCamp&search_by=num&search_banner={1}&cid={2}&ulogin={3}")
})
public class ShowCampPage extends BasePageObject implements IPriceConstructorProvider, IBannerPhrasesListProvider,
        IStrategyBlockProvider {


    private ConstructorMode constructorMode;

    //region Fields
    @Name("Информация о текущем статусе компании")
    @FindBy(css = "div.b-campaign-state__status-text")
    private WebElement campStatus;

    @Name("Кнопка открывающая попап изменения стратегии")
    @FindBy(xpath = ".//button[contains(@class, 'strategy') and contains(@class, 'switcher')]")
    private Button openStrategyPopupButton;

    @Name("Чекбокс для выделения всех баннеров")
    @FindBy(xpath = ".//span[contains(@class, 'b-groups-list__select-all')]//input")
    private CheckBoxBEM selectAllBannersCheckbox;

    @Name("Переключатель на поиске/на тематических площадках")
    @FindBy(xpath = ".//div[contains(@class, 'b-campaign-platform-switcher')]//input")
    private RadioBEM platformSwitcher;

    @Name("Селект массовых действий")
    @FindBy(xpath = ".//span[contains(@class, 'b-mass-actions__select')]//select")
    private SelectBEM massActionsSelect;

    @Name("Выполнить массовое действие")
    @FindBy(css = "button.b-mass-actions__button")
    private Button proceedMassAction;

    @Name("Кнопка сохранить на нижней панели")
    @FindBy(css = "button.b-campaign-edit-panel__save-prices")
    private Button saveButton;

    @Name("Текст диапазона корректировок ставок")
    @FindBy(css = "div.b-adjustment-rates-fork")
    private WebElement adjustmentText;

    @Name("Попап ошибок")
    @FindBy(xpath = "//div[@class='b-user-dialog__body']")
    private WebElement errorPopup;

    @Name("Кнопка Настроить регионы показа")
    @FindBy(css = "span.b-campaign-menu__change-geo")
    private WebElement changeRegionButton;

    @Name("Попап регионов показа")
    @FindBy(css = "div.test--regions-transform-editor")
    private WebElement regionPopup;

    private CampaignMenuBlock campaignMenuBlock;
    //такое же меню, как CampaignMenuBlock, но при открытом табе 'Медиаплан'
    private CampaignMediaplanMenuBlock campaignMediaplanMenuBlock;
    private CampaignInfoBlock campaignInfoBlock;
    private CampaignStateBlock campaignStateBlock;
    private BannerListTabs bannerListTabs;
    private List<GroupPreviewWithPhrasesBlockBEM> bannerPreviewWithPhrasesBlockList;
    private BannerPhrasesBlockBEM bannerPhrasesBlock;

    private BannersSearchBlock bannerSearchBlock;

    private MinusWordsPopup minusWordsPopup;
    private FirstHelpRequestPopup firstHelpRequestPopup;

    @FindBy(css = ".b-offline-set-phrases-prices__content")
    private PriceConstructorBem offlineConstructor;

    @FindBy(xpath = ".//div[contains(@class, 'b-online-set-phrases-prices ')]")
    private PriceConstructorBem inlineConstructor;

    private TagsPopupBlock tagsPopupBlock;

    private GroupEditTagsPopup groupEditTagsPopup;

    @Name("Посмотреть статистику")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=showStat')]")
    private Link showStatisticsLink;

    private BannerGroupPreviewPopupBlock bannerGroupPreviewPopupBlock;

    @Name("Список фильтров")
    @FindBy(css = ".b-feed-filter")
    private List<WebElement> filterList;

    @Name("Кнопка Возобновить/Остановить показы")
    @FindBy(css = "button.b-campaign-state__stop-resume-show")
    private WebElement resumeAndStopCampaignButton;

    private AutoCorrectionPopupBlock autoCorrectionPopupBlock;

    private EditPerformanceFilterBlock performanceFilterBlock;

    private EditDynamicFilterBlock editDynamicFilterBlock;

    @Name("Кнопка изменения сделок")
    @FindBy(css = ".b-campaign-deals__change-button")
    private Button openDealsPopupButton;

    @Name("Попап изменения сделок")
    private DealsPopup changeDealsPopup;

    @Name("Текст о привязанных сделках")
    @FindBy(css = ".b-campaign-deals__value")
    private WebElement linkedDealsText;

    @Name("Попап стратегии")
    private StrategyBlock strategyPopup;
    //endregion

    //region Field getters

    /**
     * TODO: выпилить или переделать, оставлено для обратной совместимости со старыми стратегиями
     */
    public StrategyBemBlock getStrategyChoosePopup() {
        return (StrategyBemBlock) getStrategyBlock(StrategyBemBlock.class);
    }

    private BannerListTabs getBannerListTabs() {
        return bannerListTabs;
    }

    public CampaignInfoBlock getCampaignInfoBlock() {
        return campaignInfoBlock;
    }

    public CampaignStateBlock getCampaignStateBlock() {
        return campaignStateBlock;
    }

    public BannersSearchBlock getBannersSearchBlock() {
        return bannerSearchBlock;
    }

    private CampaignMenuBlock getCampaignMenuBlock() {
        return campaignMenuBlock;
    }

    private CampaignMediaplanMenuBlock getCampaignMediaplanMenuBlock() {
        return campaignMediaplanMenuBlock;
    }

    private List<GroupPreviewWithPhrasesBlockBEM> getBannerPreviewWithPhrasesBlockList() {
        return bannerPreviewWithPhrasesBlockList;
    }

    public Optional<GroupPreviewWithPhrasesBlockBEM> getBannerPreviewWithPhrasesBlockByBannerId(Long bannerId) {
        Optional<GroupPreviewWithPhrasesBlockBEM> groupPreview = getBannerPreviewWithPhrasesBlockList().stream()
                .filter(t -> bannerId.equals(t.getBannerId())).findFirst();
        return groupPreview;
    }

    public GroupPreviewWithPhrasesBlockBEM getBannerPreviewByAdgroupIdAndExpectSuccess(Long adgroupID) {
        GroupPreviewWithPhrasesBlockBEM groupPreview = getBannerPreviewWithPhrasesBlockList().stream()
                .filter(t -> adgroupID.equals(t.getAdGroupID())).findFirst()
                .orElseThrow(() -> new DirectWebError("Группа: " + adgroupID + " не найдена"));
        groupPreview.setConfig(config);
        new JavaScriptActions(config).scrollToElement(groupPreview);
        return groupPreview;
    }

    public GroupPreviewWithPhrasesBlockBEM getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(Long bannerId) {
        GroupPreviewWithPhrasesBlockBEM groupPreview = getBannerPreviewWithPhrasesBlockByBannerId(bannerId)
                .orElseThrow(() -> new DirectWebError("Баннер: " + bannerId + " не найден"));
        groupPreview.setConfig(config);
        new JavaScriptActions(config).scrollToElement(groupPreview);
        return groupPreview;
    }

    private MinusWordsPopup getMinusWordsPopup() {
        minusWordsPopup.setConfig(config);
        return minusWordsPopup;
    }

    private FirstHelpRequestPopup getFirstHelpRequestPopup() {
        return firstHelpRequestPopup;
    }

    private PriceConstructorBem getOfflineConstructor() {
        offlineConstructor.setConfig(config);
        return offlineConstructor;
    }

    public PriceConstructorBem getInlineConstructor() {
        inlineConstructor.setConfig(config);
        return inlineConstructor;
    }

    public TagsPopupBlock getTagsPopupBlock() {
        return tagsPopupBlock;
    }

    private GroupEditTagsPopup getGroupEditTagsPopup() {
        groupEditTagsPopup.setConfig(config);
        return groupEditTagsPopup;
    }

    public WebElement getCampStatus() {
        return campStatus;
    }

    public Button getSaveButton() {
        return saveButton;
    }

    //endregion

    //region Actions
    public void switchPlatform(BannerPhrasePlatform platform) {
        platformSwitcher.selectByValue(platform.getValue());
    }

    public void fillPhraseParameters(BannerPhraseInfoWeb phraseInfo, BannerPhrasePlatform platform) {
        switchPlatform(platform);
        bannerPhrasesBlock.fillPhraseParameters(phraseInfo, platform);
    }

    public void clickActivateBannerGroup(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickActivateBannerGroup();
    }

    public void clickSendToModeration(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickSendGroupToModeration();
    }

    public void clickStopBannerGroup(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickStopBannerGroup();
    }

    public void clickDeleteBannerGroup(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).deleteBanner();
    }

    public void selectBannerCheckBox(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).selectBanner();
    }

    public void clickEditMediaplan(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickEditMediaplan();
    }

    public void setBannerCheckboxState(Long bannerId, Boolean state) {
        GroupPreviewWithPhrasesBlockBEM bannerBlock =
                getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId);
        if (state) {
            bannerBlock.selectBanner();
        } else {
            bannerBlock.deselectBanner();
        }
    }

    public void setGroupCheckboxState(Long adGroupID, Boolean state) {
        GroupPreviewWithPhrasesBlockBEM bannerBlock = getBannerPreviewByAdgroupIdAndExpectSuccess(adGroupID);
        if (state) {
            bannerBlock.selectBanner();
        } else {
            bannerBlock.deselectBanner();
        }
    }

    public void openBannerGroupPreviewAndWait(Long bannerId) {
        GroupPreviewWithPhrasesBlockBEM bannerBlock =
                getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId);
        bannerBlock.clickGroupToggleLink();
        bannerBlock.waitForBannerGroupPreviewBlock(isDisplayed());
        bannerBlock.waitForSpinLoader(not(isDisplayed()));
    }


    public void clickPricesForCampaign() {
        getCampaignMenuBlock().clickPricesForCampaign();
    }

    public void clickSave() {
        saveButton.click();
    }

    public void clickSaveAndCheckButtonTextContains(String expectedText) {
        clickSave();
        waitForElement(saveButton.getWrappedElement(), 4, WebElementMatchers.hasText(expectedText));
    }

    public void clickChangeParameters() {
        getCampaignMenuBlock().clickChangeParameters();
    }

    public void clickSearchBanners() {
        getCampaignMenuBlock().clickBannersSearch();
    }

    public void selectMassAction(BannerActionsEnum action) {
        massActionsSelect.selectByValue(action.getName());
    }

    public void clickProceedMassAction() {
        proceedMassAction.click();
    }

    public void selectAllBanners() {
        selectAllBannersCheckbox.select();
    }

    public void selectBannersTab(BannerTabsEnum bannerTab) {
        getBannerListTabs().clickOnBannerTab(bannerTab);
    }

    public void clickAddOneMoreBanner() {
        getCampaignInfoBlock().clickAddOneMoreBanner();
    }

    public void clickAddOneMoreDynamicBannerGroup() {
        getCampaignInfoBlock().clickAddOneMoreDynamicGroup();
    }

    public void clickAddOneMoreCpmBannerGroup() {
        getCampaignInfoBlock().clickOnAddOneMoreCpmGroup();
    }

    public void clickAddOneMoreMobileAppBanner() {
        getCampaignInfoBlock().clickAddOneMoreMobileAppBanner();
    }

    public void clickAddOneMoreMcGroup() {
        getCampaignInfoBlock().clickAddOneMoreMcGroup();
    }

    public void clickSendForModeration() {
        getCampaignInfoBlock().clickSendForModeration();
    }

    public void clickChangeStrategyButton() {
        getCampaignInfoBlock().clickChangeStrategy();
    }

    public void clickChangeRegionButton() {
        changeRegionButton.click();
    }

    public WebElement getRegionPopup() {
        return regionPopup;
    }

    public void fillCampaignStrategyWithSuccess(StrategyWeb strategy) {
        fillCampaignStrategyAndClickSave(strategy);
        waitForElement(strategyPopup, 5, not(WebElementMatchers.isDisplayed()));
    }

    public void fillCampaignStrategyAndCheckError(StrategyWeb strategy, String errorText) {
        fillCampaignStrategyAndClickSave(strategy);
        assertThat("Текст ошибки соответствует ожидаемомму",
                strategyPopup.getErrorText(),
                equalToIgnoringWhiteSpaceDiff(errorText));
    }

    private void fillCampaignStrategyAndClickSave(StrategyWeb strategy) {
        clickChangeStrategyButton();
        waitForElement(strategyPopup, 3, WebElementMatchers.isDisplayed());
        takeScreenshot();
        strategyPopup.fillStrategy(strategy);
        takeScreenshot();
        strategyPopup.clickSaveButton();
    }

    public void checkCampaignStrategy(StrategyWeb expectedStrategy) {
        clickChangeStrategyButton();
        waitForElement(strategyPopup, 3, WebElementMatchers.isDisplayed());
        takeScreenshot();
        strategyPopup.checkStrategy(expectedStrategy);
        strategyPopup.clickCancelButton();
        waitForElement(strategyPopup, 3, not(WebElementMatchers.isDisplayed()));
    }

    public void checkStrategyParametersText(Matcher matcher) {
        getCampaignInfoBlock().checkStrategyParameters(matcher);
    }

    public void clickPayCampaign() {
        getCampaignInfoBlock().clickPayCampaign();
    }

    public void clickOpenMediaplanPanel() {
        getCampaignMenuBlock().clickOpenMediaplanPanel();
    }

    public void clickOpenMediaplanPanelOnMediaplanTab() {
        getCampaignMediaplanMenuBlock().clickOpenMediaplanPanel();
    }

    public String getExportMediaplanToExcelLink() {
        return getCampaignMediaplanMenuBlock().getExportToExcelLink();
    }

    public void clickOpenCampaignMinusWords() {
        getCampaignMenuBlock().clickOpenCampaignMinusWords();
    }

    public void clickOpenInformer(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickOpenInformer();
    }

    public void clickCopyBannersInMediaplan() {
        getCampaignMenuBlock().clickCopyBannersInMediaplan();
    }

    public void clickSendRequestMediaplan() {
        getCampaignMenuBlock().clickSendRequestMediaplan();
    }

    public void clickCreateMediaplan() {
        getCampaignMenuBlock().clickCreateMediaplan();
    }

    public void copyBannersInMediaplan(CopyBannerParameters copyBannerParameters) {
        getCampaignMenuBlock().clickCopyBannersInMediaplan();
        getCampaignMenuBlock().fillCopyBannerParameters(copyBannerParameters);
        takeScreenshot();
        getCampaignMenuBlock().clickCopyButton();
    }

    public void clickShowRecommendations() {
        getCampaignInfoBlock().clickShowRecommendations();
    }

    public void clickFirstHelpComment() {
        getCampaignStateBlock().clickFirstHelpComment();
    }

    public void openBannerMinusWordsPopup(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickMinusWords();
    }

    public void fillCampaignMinusWordsSaveAndExpectSuccess(List<String> minusWords) {
        fillCampaignMinusWordsAndClickSave(minusWords);
        assertThat("не исчез попап", getMinusWordsPopup(),
                should(not(WebElementMatchers.exists()))
                        .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(5)))
        );
    }

    public void fillCampaignMinusWordsAndClickSave(List<String> minusWords) {
        clickOpenCampaignMinusWords();
        getMinusWordsPopup().saveMinusWords(minusWords);
    }

    public void fillBannerMinusAndSave(Long bannerId, List<String> minusWords) {
        openBannerMinusWordsPopup(bannerId);
        getMinusWordsPopup().saveMinusWords(minusWords);
    }

    public void orderFirstHelp(HelpRequestInfo helpRequestInfo) {
        getCampaignMenuBlock().clickFirstHelpRequest();
        getFirstHelpRequestPopup().fillParameters(helpRequestInfo);
        takeScreenshot();
        getFirstHelpRequestPopup().clickOnSendButton();
    }

    public void clickPriceCommonTab() {
        getOfflineConstructor().clickPriceCommonTab();
    }

    public void clickPriceWizardTab() {
        getOfflineConstructor().clickPriceWizardTab();
    }

    public void clickOnAddOrEditTagLinkOnTagsPopupBlock() {
        getTagsPopupBlock().clickOnAddOrEditTagLink();
    }

    public void clickOnShowBannersWithoutTagsLink() {
        getTagsPopupBlock().clickOnShowBannersWithoutTagsLink();
    }

    public void checkTags(Matcher<Iterable<? extends String>> matcher) {
        getTagsPopupBlock().checkTags(matcher);
    }

    public void clickOnTag(String tag) {
        getTagsPopupBlock().clickOnTag(tag);
    }

    public void clickOpenTags() {
        getCampaignMenuBlock().clickTags();
    }

    public void fillNewTagsForBanner(Long bannerId, String... tags) {
        GroupPreviewWithPhrasesBlockBEM block = getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId);
        block.clickOnOpenTags();
        block.fillNewTags(tags);
    }

    public void clickOnShowStatisticsLink() {
        showStatisticsLink.click();
    }

    public void fillMinusKeywordsAndSave(Long bannerId, String minusKeywords) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).fillMinusKeywordsAndSave(minusKeywords);
    }
    //endregion

    //region Assertions
    public void checkCampStatus(Matcher<WebElement> matcher) {
        assertThat("статус кампании неверный", campStatus, matcher);
    }

    public void checkBannerTabListNotDisplayed() {
        assertThat("отсутствует список табов", isNull(bannerListTabs.getBannerTab(BannerTabsEnum.ALL)));
    }

    public void checkBannerTabCount(BannerTabsEnum bannerTab, Matcher matcher) {
        bannerListTabs.checkBannersTabCount(bannerTab, matcher);
    }

    public void checkBannerTab(BannerTabsEnum bannerTab, Matcher matcher) {
        bannerListTabs.checkBannersTab(bannerTab, matcher);
    }

    public void checkShowRecommendationsLink(Matcher<WrapsElement> matcher) {
        getCampaignInfoBlock().checkShowRecommendationsLink(matcher);
    }

    public void checkBannerPreviewParameters(BannerInfoWeb expectedBanner) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(expectedBanner.getBannerId())
                .checkBannerParameters(expectedBanner);
    }

    public void shouldSeeAutoCorrectionBannerPreview(Long bannerId, Matcher<WebElement> matcher) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).shouldSeeAutoCorrection(matcher);
    }

    public void checkAutoCorrectionBanner(BannerInfoWeb expectedBanner) {
        autoCorrectionPopupBlock.checkBeforeAutoCorrectionBanner(expectedBanner);
    }

    public void checkAutoCorrectionBannerPreviewPopup(BannerInfoWeb expectedBanner) {
        bannerGroupPreviewPopupBlock.clickOpenInformer();
        autoCorrectionPopupBlock.checkBeforeAutoCorrectionBanner(expectedBanner);
    }

    public void checkMobileAppBannerPreviewParameters(MobileAppBannerInfoWeb expectedBanner) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(expectedBanner.getBannerId())
                .checkMobileAppBannerParameters(expectedBanner);
    }


    public void checkBannerOnGroupPreview(Long parentBannerId, Long childBannerId, Matcher matcher) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(parentBannerId)
                .checkBannerOnGroupPreview(childBannerId, matcher);
    }

    public void checkAdjustmentRangeText(GroupMultiplierStatsWeb expectedGroupMultiplierStats) {
        GroupMultiplierStatsWeb actual = new GroupMultiplierStatsWeb();
        actual.setAdjustmentUpperBound(adjustmentText.getText().replaceFirst(".* (\\d+)%$", "$1"));
        Pattern pattern = Pattern.compile(".* (\\d+)% .* (\\d+)%$");
        java.util.regex.Matcher matcher = pattern.matcher(adjustmentText.getText());

        if (matcher.find()) {
            actual.setAdjustmentLowerBound(matcher.group(1));
        }

        assertThat("неверный диапазон корректировок ставок", actual,
                samePropertyValuesAs(expectedGroupMultiplierStats));
    }

    public void checkCampaignMinusWords(Matcher<Collection<? extends String>> matcher) {
        getCampaignMenuBlock().clickOpenCampaignMinusWords();
        List<String> actual = getMinusWordsPopup().getMinusWords();
        getMinusWordsPopup().cancelButton.click();
        assertThat("неверные минус слова для всей кампании", actual, matcher);
    }

    public void checkBannerMinusWords(Long bannerId, List<String> expectedMinusWords) {
        openBannerMinusWordsPopup(bannerId);
        List<String> actual = getMinusWordsPopup().getMinusWords();
        getMinusWordsPopup().cancelButton.click();
        assertThat("неверные минус слова для всей кампании", actual, hasSameItemsAsCollection(expectedMinusWords));
    }

    public void checkMinusKeywordsOnPhrase(Matcher matcher,
                                           BannerPhrasePlatform platform,
                                           MinusKeyWordsTypes type,
                                           BannerPhraseInfoWeb exceptedPhrase) {
        bannerPhrasesBlock.checkMinusKeywordsOnPhrase(matcher, platform, type, exceptedPhrase);
    }

    public void checkFirstHelpStatus(Matcher<WebElement> matcher) {
        getCampaignStateBlock().checkFirstHelpStatus(matcher);
    }

    public void checkFirstEditBannerLink(Matcher<WrapsElement> matcher) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(getFirstBannerId()).checkEditGroupLink(matcher);
    }

    public void setTagsForGroup(Long adGroupID, String... tags) {
        GroupPreviewWithPhrasesBlockBEM block = getBannerPreviewByAdgroupIdAndExpectSuccess(adGroupID);
        block.clickOnOpenTags();
        block.setTagCheckBoxes(tags);
    }

    public void setTagsForBanner(Long bannerId, String... tags) {
        GroupPreviewWithPhrasesBlockBEM block = getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId);
        block.clickOnOpenTags();
        block.setTagCheckBoxes(tags);
    }

    public void saveNewTagsForBanner(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickSaveTags();
    }

    public void setTagsForSelectedBannersUsingGroupAction(String... tags) {
        getGroupEditTagsPopup().saveNewTags(tags);
    }

    //endregion

    public List<Long> getBannerIds() {
        return getBannerPreviewWithPhrasesBlockList().stream().map(x -> x.getBannerId()).collect(toList());
    }

    public Long getFirstBannerId() {
        if (getBannerPreviewWithPhrasesBlockList().isEmpty()) {
            throw new DirectWebError("Список баннеров пуст");
        } else {
            return getBannerPreviewWithPhrasesBlockList().get(0).getBannerId();
        }
    }

    public Long getFirstAdGroupID() {
        if (getBannerPreviewWithPhrasesBlockList().isEmpty()) {
            throw new DirectWebError("Список групп пуст");
        } else {
            return getBannerPreviewWithPhrasesBlockList().get(0).getAdGroupID();
        }
    }

    public Long getLastBannerId() {
        if (getBannerPreviewWithPhrasesBlockList().isEmpty()) {
            throw new DirectWebError("Список баннеров пуст");
        } else {
            return getLast(getBannerPreviewWithPhrasesBlockList()).getBannerId();
        }
    }

    public void clickEditBannerGroupInfoLinkByID(Long adGroupID) {
        getBannerPreviewByAdgroupIdAndExpectSuccess(adGroupID).clickOnEditGroupLink();
    }

    public BannerPhraseInfoWeb getPhraseParameters(BannerPhraseInfoWeb expectedPhrase, BannerPhrasePlatform platform) {
        switchPlatform(platform);
        return bannerPhrasesBlock.getPhaseInfo(expectedPhrase, platform);
    }

    public void forConstructorMode(ConstructorMode mode) {
        this.constructorMode = mode;
    }

    @Override
    public PriceConstructorBem getConstructor() {
        if (constructorMode == null) {
            throw new DirectWebError("Укажите тип конструктора");
        }
        switch (constructorMode) {
            case INLINE:
                return getInlineConstructor();
            case OFFLINE:
                return getOfflineConstructor();
        }
        return null;
    }

    @Override
    public BannerPhrasesBlockBEM getBannerPhrasesBlock() {
        bannerPhrasesBlock.setConfig(config);
        return bannerPhrasesBlock;
    }

    @Name("Попап - Заявка на Первую помощь")
    @FindBy(css = "div.b-campaign-help-request")
    public static class FirstHelpRequestPopup extends HtmlElement {

        @Name("Недельный бюджет")
        @FindBy(css = ".b-campaign-help-request__week-budget input")
        private TextInput budgetInput;

        @Name("Пожелания клиента")
        @FindBy(css = ".b-campaign-help-request__client-comment textarea")
        private TextInput clientWishes;

        @Name("Кнопка Отправить")
        @FindBy(css = "button[type=submit]")
        private Button sendButton;

        public void clickOnSendButton() {
            sendButton.click();
        }

        public void fillParameters(HelpRequestInfo helpRequestInfo) {
            if (helpRequestInfo != null) {
                fillTextInput(budgetInput, helpRequestInfo.getBudget().toString());
                for (String wish : helpRequestInfo.getClientWishes()) {
                    clientWishes.sendKeys(wish);
                    clientWishes.sendKeys("\n");
                }
            }
        }
    }

    @Name("Попап минус-слов на странице кампании")
    @FindBy(xpath = ".//div[contains(@class, 'popup_visibility_visible')]//div[contains(@class, 'b-outboard-controls__popup-content')]")
    public static class MinusWordsPopup extends ExtendedHtmlElement {
        @Name("Блок текста")
        @FindBy(css = "textarea")
        private TextAreaBEM input;

        @Name("Сохранить")
        @FindBy(css = "button.b-outboard-controls__accept-button")
        private Button okButton;

        @Name("Отмена")
        @FindBy(css = "button.b-outboard-controls__decline-button")
        private Button cancelButton;

        public List<String> getMinusWords() {
            return Arrays.asList(input.getText().replace(" ", "").split("-"));
        }

        public void saveMinusWords(List<String> minusWords) {
            if (minusWords == null) {
                return;
            }
            fillTextInput(input, StringUtils.join(minusWords, ", "));
            okButton.click();
        }
    }

    @Override
    public IStrategyBlock getStrategyBlock(Class<? extends StrategyBemBlock> strategyBemBlockClass) {
        StrategyBemBlock strategyBemBlock = HtmlElementLoader.create(strategyBemBlockClass, config.getDriver());
        strategyBemBlock.setConfig(config);
        return strategyBemBlock;
    }

    @Override
    public void openStrategyBlock() {
        openStrategyPopupButton.click();
    }

    public void checkContextSearchSwitcher(Matcher matcher) {
        assertThat("переключатель на поиске/на тематике не соответствует ожиданиям",
                platformSwitcher, matcher);
    }

    // Banner Group
    public String getBannersGroupTitle(Long bannerId) {
        return getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).getBannerGroupTitle();
    }

    public void clickBannersGroupInfoLink(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickGroupToggleLink();
    }

    public void clickCopyBannersGroupLink(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickOnCopyGroupLink();
    }

    public void clickEditGroupLink(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).clickOnEditGroupLink();
    }

    public Boolean getBannertGroupPreviewItemTumblerStatus(Long bannerId) {
        return bannerGroupPreviewPopupBlock.getBannertGroupPreviewItemTumblerStatus(bannerId);
    }

    public void clickBannersGroupSaveButton() {
        bannerGroupPreviewPopupBlock.clickSaveButton();
        waitForElement(bannerGroupPreviewPopupBlock, 3, not(isDisplayed()));
    }

    public void clickBannersGroupCloseWebElement() {
        bannerGroupPreviewPopupBlock.clickCloseWebElement();
    }

    public void clickBannersGroupCancelButton() {
        bannerGroupPreviewPopupBlock.clickCancelButton();
    }

    public void clickBannersGroupArchiveWebElement() {
        bannerGroupPreviewPopupBlock.clickArchiveWebElement();
    }

    public void clickBannersGroupAllBannersWebElement() {
        bannerGroupPreviewPopupBlock.clickAllBannersWebElement();
    }

    public void selectPage(String pageNumber) {
        bannerGroupPreviewPopupBlock.selectPage(pageNumber);
    }

    public void selectBannersGroupTumbler(Long bannerId, Boolean status) {
        bannerGroupPreviewPopupBlock.selectTumbler(bannerId, status);
    }

    public void checkBannersGroupItemBean(Long bannerId, BeanEquals<BannerInfoWeb> matcher) {
        BannerInfoWeb expectedBean = matcher.getExpectedBean();
        if (expectedBean.getBannerId() == null || expectedBean.getBannerId().equals(0L)) {
            expectedBean.setBannerId(bannerId);
        }
        checkBannersGroupItemBean(wrap(expectedBean));
    }

    public void checkMobileAppBannersGroupItemBean(Long bannerId, BeanEquals<MobileAppBannerInfoWeb> matcher) {
        MobileAppBannerInfoWeb expectedBean = matcher.getExpectedBean();
        expectedBean.setBannerId(bannerId);
        checkMobileAppBannersGroupItemBean(wrap(expectedBean));
    }

    public void checkBannersGroupItemBean(IBeanWrapper<BannerInfoWeb> bannerInfo) {
        BannerInfoWeb expectedBean = bannerInfo.getBean();
        AllureUtils.addJsonAttachment("Параметры баннера", expectedBean.toString());
        bannerGroupPreviewPopupBlock.checkBannerParameters(expectedBean);
    }

    public void checkMobileAppBannersGroupItemBean(IBeanWrapper<MobileAppBannerInfoWeb> bannerInfo) {
        AllureUtils.addJsonAttachment("Параметры баннера", bannerInfo.toString());
        bannerGroupPreviewPopupBlock.checkMobileAppBannerParameters(bannerInfo.getBean());
    }

    public void checkBannersGroupTumblerStatus(Long bannerId, Matcher<Boolean> matcher) {
        Boolean status = getBannertGroupPreviewItemTumblerStatus(bannerId);
        assertThat("статус баннера не соответствует ожиданию", status, matcher);
    }

    public void checkPreviewGroup(Long bannerId, Matcher<WebElement> matcher) {
        GroupPreviewWithPhrasesBlockBEM groupPreviewBlock = getBannerPreviewWithPhrasesBlockByBannerId(bannerId)
                .orElse(null);
        assertThat("блок предпросмотра группы соответсвует ожиданиям", groupPreviewBlock, matcher);
    }

    public void checkCampaignSum(Matcher matcher) {
        getCampaignInfoBlock().checkCampaignSum(matcher);
    }

    public void checkDiscountBonus(Matcher matcher) {
        getCampaignInfoBlock().checkDiscountBonus(matcher);
    }

    public void checkBannerGroupCount(Long bannerId, Matcher matcher) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).checkBannerGroupCount(matcher);
    }

    public void clickBannersGroupRemoveButton(Long bannerId) {
        bannerGroupPreviewPopupBlock.clickRemoveButton(bannerId);
    }

    public void checkBannersGroupItem(Long bannerId, Matcher<WebElement> matcher) {
        bannerGroupPreviewPopupBlock.checkBannerGroupItem(bannerId, matcher);
    }

    public void clickBannersGroupArchiveItem(Long bannerId) {
        bannerGroupPreviewPopupBlock.clickArchiveItem(bannerId);
    }

    public void clickBannersGroupUnArchiveItem(Long bannerId) {
        bannerGroupPreviewPopupBlock.clickUnArchiveItem(bannerId);
    }

    public void clickBannerPreviewType(BannerPreviewType prevType) {
        bannerGroupPreviewPopupBlock.clickPreviewType(prevType);
    }

    public void waitWhileBannerGroupPreviewPopupLoadingComplete() {
        bannerGroupPreviewPopupBlock.waitForLoadingComplete();
    }

    public void checkPricesForCampaignLink(Matcher matcher) {
        getCampaignMenuBlock().checkPricesForCampaignLink(matcher);
    }

    public void checkInlineConstructor(Matcher matcher) {
        assertThat("он-лайн конструктор не соответствует ожиданиям", inlineConstructor, matcher);
    }

    public void checkBannerFlag(Long bannerId, Matcher<WebElement> matcher) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).checkBannerFlag(matcher);
    }

    public void setDietarySupplBannerFlag(Long bannerId) {
        getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).setDietarySupplBannerFlag();
    }

    @Name("Ссылка на 'Перевести клиента в легкий интерфейс'")
    @FindBy(xpath = "div[contains(@class, 'easy-switcher')]/a")
    private WebElement easyInterfaceSwitcher;

    public void switchInterface() {
        easyInterfaceSwitcher.click();
    }

    private WebElement getFilterRow(String filterId) {
        Pattern pattern =
                Pattern.compile("\"filter_id\":\"?" + filterId); //Для перформанса ставим кавычку, для ДО нет =)
        return filterList.stream()
                .filter(t -> pattern.matcher(t.getAttribute("data-bem")).find())
                .findFirst().orElseThrow(() -> new DirectWebError("Фильтр с номером " + filterId + " не найден"));
    }

    public void clickEditFilter(String filterId) {
        WebElement filter = getFilterRow(filterId)
                .findElement(By.xpath(".//div[contains(@data-bem, '\"name\":\"filter_name\"')]"));
        new JavaScriptActions(config).scrollToElement(filter);
        filter.click();
    }

    public void fillPerformanceFilter(PerformanceFeedFilter feedFilter) {
        performanceFilterBlock.setConfig(config);
        clickEditFilter(feedFilter.getFilterId());
        performanceFilterBlock.fillParameters(feedFilter);
    }

    public void fillDynamicFilter(DynamicFeedFilter dynamicFeedFilter) {
        editDynamicFilterBlock.setConfig(config);
        clickEditFilter(dynamicFeedFilter.getFilterId());
        editDynamicFilterBlock.fillParameters(dynamicFeedFilter);
    }

    public void checkPerformanceFilter(BeanDifferMatcher<PerformanceFeedFilter> matcher) {
        FeedFilterBase filter = matcher.getExpectedBean();
        clickEditFilter(filter.getFilterId());
        performanceFilterBlock.checkParameters(matcher);
    }

    public void checkDynamicFilter(BeanDifferMatcher<DynamicFeedFilter> matcher) {
        FeedFilterBase filter = matcher.getExpectedBean();
        clickEditFilter(filter.getFilterId());
        editDynamicFilterBlock.checkParameters(matcher);
    }

    public void shouldSeeFilterPopupBlock(Matcher matcher) {
        assertThat("блок фильтра не соответствует ожиданиям",
                performanceFilterBlock, should(matcher)
                        .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(5))));
    }

    public RadioBEM getPlatformSwitcher() {
        return platformSwitcher;
    }

    public void clickResumeAndStopCampaignButton() {
        resumeAndStopCampaignButton.click();
        waitForElement(resumeAndStopCampaignButton, 3, isEnabled());
    }

    public void shouldSeeResumeAndStopCampaignButton(Matcher matcher) {
        assertThat(format("кнопка соответствует ожиданию: %s", matcher.toString()), resumeAndStopCampaignButton,
                matcher);
    }

    public void fillDynamicTargetPriceInGroup(Long adgroupId, String targetName, Float price) {
        getBannerPreviewByAdgroupIdAndExpectSuccess(adgroupId).getDynamicTargetRowByName(targetName).setPrice(price);
        waitForElement(saveButton.getWrappedElement(), 1, isEnabled());
    }

    public void fillSmartFilterPriceInGroup(Long adgroupId, String filterName, Float price) {
        getBannerPreviewByAdgroupIdAndExpectSuccess(adgroupId).getSmartFilterRowByName(filterName).setPrice(price);
        waitForElement(saveButton.getWrappedElement(), 1, isEnabled());
    }

    public void checkDynamicTargetPriceInGroup(Long adgroupId, String targetName, String expectedPrice) {
        getBannerPreviewByAdgroupIdAndExpectSuccess(adgroupId).getDynamicTargetRowByName(targetName)
                .checkPrice(expectedPrice);
    }

    public void checkSmartFilterPriceInGroup(Long adgroupId, String filterName, String expectedPrice) {
        getBannerPreviewByAdgroupIdAndExpectSuccess(adgroupId).getSmartFilterRowByName(filterName)
                .checkPrice(expectedPrice);
    }

    public void openAdGroupMinusWordsPopup(Long adGroupID) {
        getBannerPreviewByAdgroupIdAndExpectSuccess(adGroupID).clickMinusWords();
    }

    public void shouldSeeErrorPopupText(Matcher<WebElement> matcher) {
        waitForElement(errorPopup, 5, matcher);
    }

    public void clickOpenDealPopupAndWaitDealPopupDisplayed() {
        openDealsPopupButton.click();
        waitForElement(changeDealsPopup, 5, WebElementMatchers.isDisplayed());
    }

    public DealsPopup onDealsPopup() {
        return changeDealsPopup;
    }

    public void checkLinkedDealsText(Matcher<String> matcher) {
        assertThat("текст соответствует ожиданию", linkedDealsText.getText(), matcher);
    }
}