package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.BannerGroupPreviewBlock;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import java.util.ArrayList;
import java.util.List;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

/**
 * Created by aleran on 13.10.2015.
 */
public class BannerPreviewContentBlockBEM extends BannerPreviewContentBlockBase {

    @Name("Заголовок баннера")
    @FindBy(css = "div.b-banner-preview2__title a")
    private Link bannerTitle;

    @Name("Текст баннера")
    @FindBy(css = "div.b-banner-preview2__body")
    private WebElement bannerBody;

    @Name("Домен")
    @FindBy(css = "div.b-banner-preview2__domain")
    private WebElement bannerDomain;

    @Name("Ссылка открывающая попап с быстрыми ссылками для объявления")
    @FindBy(xpath = ".//div[contains(@class, 'b-banner-preview2__additions')]" +
            "//span[contains(@class, 'b-banner-preview2__addition')]")
    private Link siteLinks;

    @Name("Попап сайтлинков")
    @FindBy(xpath = "//div[contains(@class, 'b-banner-preview2__sitelinks')]")
    private SiteLinksPopup siteLinksPopup;


    private BannerGroupPreviewBlock bannerGroupPreviewBlock;
    //endregion

    //region Field getter

    private BannerGroupPreviewBlock getBannerGroupPreviewBlock() {
        bannerGroupPreviewBlock.setConfig(config);
        return bannerGroupPreviewBlock;
    }

    //end region

    //region Actions

    public void checkBannerOnGroupPreview(Long BannerID, Matcher matcher) {
        MatcherAssert.assertThat(getBannerGroupPreviewBlock().getBannerOnGroupPreviewBlock(BannerID), matcher);
    }

    public void waitForBannerGroupPreviewBlock(Matcher<WebElement> matcher) {
        waitForElement(getBannerGroupPreviewBlock(), 5, matcher);
    }

    public void waitForSpinLoader(Matcher matcher) {
        waitForElement(getBannerGroupPreviewBlock().getSpinLoader(), 5, matcher);
    }
    //endregion

    //region Assertions
    public void checkSiteLinks(SiteLinkInfoWeb[] expectedSiteLinks) {
        if (expectedSiteLinks == null) {
            return;
        }
        siteLinks.click();
        siteLinksPopup.checkParameters(expectedSiteLinks);
    }

    public void checkParameters(BannerInfoWeb expectedBean) {
        Assert.assertThat("неверные параметры баннера", getFormFieldsAccording(expectedBean),
                beanEquals(expectedBean));
        checkSiteLinks(expectedBean.getSitelinks());
    }
    //endregion

    public BannerInfoWeb getFormFieldsAccording(BannerInfoWeb expectedBean) {
        BannerInfoWeb actualBean = inAccordanceWith(expectedBean).forNew(BannerInfoWeb.class)
                .set("title", bannerTitle, on(Link.class).getText())
                .set("text", bannerBody, on(WebElement.class).getText())
                .set("domain", bannerDomain, on(WebElement.class).getText())
                .set("geo", this, on(BannerPreviewContentBlockBEM.class).getRegionsIDs(expectedBean.getGeo()))
                .getActualBean();
        actualBean.setBannerId(expectedBean.getBannerId());
        actualBean.setCampaignId(expectedBean.getCampaignId());
        return actualBean;
    }

    @Name("Попап сайт-линков")
    public static class SiteLinksPopup extends HtmlElement {
        @Name("Список ссылок")
        @FindBy(xpath = ".//a[contains(@class, 'b-banner-preview2__sitelink') and @href != '']")
        private List<Link> siteLinks;

        private List<Link> getSiteLinks() {
            return siteLinks;
        }

        public void checkParameters(SiteLinkInfoWeb[] expectedBean) {
            SiteLinkInfoWeb[] actualBean = getFormFieldsAccording(expectedBean);
            for (int i = 0; i < expectedBean.length; i++) {
                Assert.assertThat("быстрые ссылки не соответствует ожиданиям", actualBean[i],
                        beanEquals(expectedBean[i]));
            }
        }

        public SiteLinkInfoWeb[] getFormFieldsAccording(SiteLinkInfoWeb[] expectedBean) {
            List<SiteLinkInfoWeb> result = new ArrayList<>();
            for (Link siteLink : getSiteLinks()) {
                String href = siteLink.getReference().substring(0, siteLink.getReference().length() - 1);
                String title = siteLink.getText();
                result.add(new SiteLinkInfoWeb(title, href));
            }
            return result.toArray(new SiteLinkInfoWeb[result.size()]);
        }
    }
}
