package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.contactinfo.Regions;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.Matchers.equalTo;

/**
 * Created by aleran on 12.10.2015.
 */
public class BannerPreviewContentBlockBase extends ExtendedHtmlElement {

    @Name("Регионы показа")
    @FindBy(css = "div.b-group-regions__names")
    private WebElement bannerGeo;

    @Name("Возрастное ограничение")
    @FindBy(css = ".b-banner-age-label2__label .b-banner-age-label2__value")
    private WebElement ageValue;

    @Name("Возрастное ограничение")
    @FindBy(css = ".b-banner-age-label2__label span")
    private WebElement ageAddition;

    @Name("Изменить возрастное ограничение")
    @FindBy(css = ".b-banner-age-label2__link")
    private WebElement editAge;

    //Попап отображается, когда список регионов не помещается в превью
    @Name("Регионы показа в попапе")
    @FindBy(xpath = ".//div[contains(@class,'b-group-regions__names-popup')]")
    private WebElement bannerGeoPopup;

    public String getAgeRestriction() {
        return ageValue.getText();
    }

    public String getAgeAddition() {
        return ageAddition.getText();
    }

    public void clickEditAgeRestriction() {
        editAge.click();
    }

    public String getRegionsIDs(String expectedGeo) {
        String regions;
        if (WebElementMatchers.exists().matches(bannerGeoPopup)) {
            regions = bannerGeoPopup.getAttribute("data-bem").split("names\":")[1].
                    replace("{", "").replace("}", "").replace("\"", "");
        } else {
            regions = bannerGeo.getText();
        }
        List<String> regionsText = Arrays.asList(regions.split(", "));
        List<String> regionsIDs = regionsText.stream().map(regionText -> Regions.getRegion(regionText).getRegionID()).collect(Collectors.toList());
        if (expectedGeo.equals("0")) {
            if (equalTo(regionsIDs).matches(Regions.getAllWorldIDs())) {
                return "0";
            }
        }
        return StringUtils.join(regionsIDs, ",");
    }
}
