package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import java.util.concurrent.TimeUnit;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.TestEnvironment;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(css = "div.b-campaign-info")
public class CampaignInfoBlock extends HtmlElement {

    //region Fields

    @Name("Остаток средств на кампании")
    @FindBy(xpath = ".//td[./a[contains(@href, 'cmd=pay')]]")
    private WebElement campaignSum;

    @Name("Скидочный бонус")
    @FindBy(css = ".b-campaign-info__bonus-money")
    private WebElement doscountBonus;

    @Name("Ссылка оплатить")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=pay')]")
    private Link payCampaign;

    @Name("Ссылка Посмотреть рекомендации")
    @FindBy(css = "a.b-campaign-info__optimize-ready-more")
    private Link showRecommendations;

    @Name("Отправить на модерацию")
    @FindBy(xpath = ".//form[.//input[@value='orderCamp']]//button[@type='submit']")
    private WebElement sendForModeration;

    @Name("Добавить еще объявление")
    @FindBy(xpath = ".//form[.//input[@value='addBannerMultiEdit']]//button[@type='submit']")
    private Button addOneMoreBanner;

    @Name("Добавить еще группу РМП")
    @FindBy(xpath = ".//form[.//input[@value='addAdGroupsMobileContent']]//button[@type='submit']")
    private Button addOneMoreMobileAppBanner;

    @Name("Добавить еще одну ДО группу")
    @FindBy(xpath = ".//form[.//input[@value='addDynamicAdGroups']]//button[@type='submit']")
    private Button addOneMoreDynamicGroup;

    @Name("Добавить еще одну МС группу")
    @FindBy(xpath = ".//form[contains(@class, 'b-campaign-info__main-form i-form')]//button[@type='submit']")
    private Button addOneMoreMcGroup;

    @Name("Добавить еще одну cpm группу")
    @FindBy(xpath = ".//button[contains(@class, 'button_action_add-group-beta')]")
    private Button addOneMoreCpmGroup;

    @Name("Название стратегии")
    @FindBy(xpath = ".//span[contains(@class, 'b-strategy-choose__current-title')]")
    private WebElement strategyName;

    @Name("Параметры стратегии")
    @FindBy(css = "table.b-campaign-info__details")
    private WebElement strategyParameters;

    @Name("Изменить параметры стратегии")
    @FindBy(xpath = ".//button[contains(@class,'b-campaign-strategy2__switcher')]")
    private Button changeStrategyParameters;
    //endregion

    //region Getters
    private String getCampaignSum() {
        return campaignSum.getText().replaceAll("\\D\\.", "")
                .replaceAll("[^0-9." + String.valueOf((char) 160) + "]", "");
    }

    private String getDiscountBonus() {
        return doscountBonus.getText().replaceAll("\\D\\.", "")
                .replaceAll("[^0-9." + String.valueOf((char) 160) + "]", "");
    }
    //endregion

    //region Actions
    public void clickChangeStrategy() {
        changeStrategyParameters.click();
    }

    public void clickAddOneMoreBanner() {
        addOneMoreBanner.click();
    }

    public void clickAddOneMoreMobileAppBanner() {
        addOneMoreMobileAppBanner.click();
    }

    public void clickAddOneMoreDynamicGroup() {
        addOneMoreDynamicGroup.click();
    }

    public void clickOnAddOneMoreCpmGroup() {
        addOneMoreCpmGroup.click();
    }

    public void clickSendForModeration() {
        sendForModeration.click();
    }

    public void clickShowRecommendations() {
        showRecommendations.click();
    }

    public void clickPayCampaign() {
        payCampaign.click();
    }

    public void clickAddOneMoreMcGroup() {
        addOneMoreMcGroup.click();
    }
    //endregion

    //region Assertions
    public void checkShowRecommendationsLink(Matcher<WrapsElement> matcher) {
        assertThat("ссылка Посмотреть рекомендации не прошла проверку", showRecommendations, matcher);
    }

    public void checkStrategyParameters(Matcher matcher) {
        assertThat("неверный текст параметров стратегии", strategyParameters, should(matcher)
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                        TestEnvironment.getWebDriverConfiguration().getImplicitlyWaitTimeout()))));
    }

    public void checkCampaignSum(Matcher matcher) {
        assertThat("остаток средств на кампании не соответсвует ожиданиям", getCampaignSum(), matcher);
    }

    public void checkDiscountBonus(Matcher matcher) {
        assertThat("скидочный бонус не соответсвует ожиданиям", getDiscountBonus(), matcher);
    }
    //endregion
}
