package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

/**
 * @author shmykov
 */
@FindBy(css = "div.b-campinfo__navlinks")
public class CampaignMediaplanMenuBlock extends HtmlElement {

    //region Fields
    @Name("Открыть панель медиаплана")
    @FindBy(css = "div.b-campinfo__navlinks span.b-dropdowna__switcher span")
    private Link openMediaplanPanel;

    private MediaplanPopupBlock mediaplanPopupBlock;
    //endregion

    //region Field getters
    public MediaplanPopupBlock getMediaplanPopupBlock() {
        return mediaplanPopupBlock;
    }
    //endregion

    //region Actions
    public void clickOpenMediaplanPanel() {
        openMediaplanPanel.click();
    }

    public String getExportToExcelLink() {
        return getMediaplanPopupBlock().getExportToExcelLink();
    }
    //endregion
}