package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.mediaplan.CopyBannerParameters;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.CopyBannerPopupBlock;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = ".//div[contains(@class, 'b-campaign-menu')][@data-bem]")
public class CampaignMenuBlock extends HtmlElement {

    //region Fields
    @Name("Изменить параметры")
    @FindBy(xpath = ".//a[contains(@href, 'editCamp')][contains(@href, 'cid')]")
    private Link changeParameters;

    @Name("Виртуальные визитки")
    @FindBy(xpath = ".//a[contains(@href, 'manageVCards')]")
    private Link virtualCards;

    @Name("Цены для всей кампании")
    @FindBy(xpath = ".//span[contains(@class, 'b-offline-set-phrases-prices ')]/span")
    private WebElement pricesForCampaign;

    @Name("Открыть панель медиаплана")
    @FindBy(css = "li.b-campaign-menu__mediaplan .dropdown__switcher .link__inner")
    private Link openMediaplanPanel;

    @Name("Поиск объявлений")
    @FindBy(xpath = ".//li[contains(@class, 'b-campaign-menu__item_for_search')]//span")
    private WebElement bannersSearch;

    @Name("Метки")
    @FindBy(css = ".b-campaign-menu__item_for_tags .link__inner")
    private WebElement tags;

    @Name("Заявка на Первую помощь")
    @FindBy(xpath = ".//li[.//div[contains(@class,'b-campaign-help-request')]]//span[contains(@class,'link__inner')]")
    private Link firstHelpRequest;

    @Name("Скопировать объявления в медиаплан")
    @FindBy(css = "li.b-campaign-menu__item_for_mediaplan .dropdown__switcher .link__inner")
    private Link copyToMediaplan;

    @Name("Единый набор минус-слов")
    @FindBy(xpath = ".//a[contains(@class, 'b-minus-words-control__switcher-link')]")
    private Link campaignMinusWords;

    private MediaplanPopupBlock mediaplanPopupBlock;
    private CopyBannerPopupBlock copyBannerPopupBlock;
    //endregion

    //region Field getters
    public MediaplanPopupBlock getMediaplanPopupBlock() {
        return mediaplanPopupBlock;
    }
    //endregion

    //region Actions
    public void clickChangeParameters(){
        changeParameters.click();
    }

    public void clickBannersSearch() {
        bannersSearch.click();
    }

    public void clickPricesForCampaign() {
        pricesForCampaign.click();
    }

    public void clickOpenMediaplanPanel() {
        openMediaplanPanel.click();
    }

    public void clickOpenCampaignMinusWords() {
        campaignMinusWords.click();
    }

    public void clickCreateMediaplan() {
        getMediaplanPopupBlock().clickCreateMediaplanLink();
    }

    public void clickFirstHelpRequest() {
        firstHelpRequest.click();
    }

    public void clickSendRequestMediaplan() {
        getMediaplanPopupBlock().clickSendRequestMediaplanLink();
    }

    public void clickCopyBannersInMediaplan() {
        copyToMediaplan.click();
    }

    public void fillCopyBannerParameters(CopyBannerParameters copyBannerParameters) {
        copyBannerPopupBlock.fillCopyBannerParameters(copyBannerParameters);
    }

    public void clickCopyButton() {
        copyBannerPopupBlock.clickCopy();
    }

    public void checkPricesForCampaignLink(Matcher matcher) {
        assertThat("ссылка 'Цены для всей кампании' не соответсвует ожиданиям", pricesForCampaign, matcher);
    }

    public void clickTags() {
        tags.click();
    }
    //endregion
}