package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(css = "div.b-campaign-state")
public class CampaignStateBlock extends HtmlElement {

    //region Fields
    @Name("Статус заявки на первую помощь")
    @FindBy(xpath = ".//div[contains(@class,'b-campaign-state__optimize-content')]")
    private WebElement firstHelpStatus;

    @Name("'Подробнее' к заявке на Первую помощь")
    @FindBy(xpath = ".//span[contains(@data-bem,'cmd=viewOptimizingComment')]")
    private Link firstHelpCommentLink;
    //endregion

    //region Actions
    public void clickFirstHelpComment() {
        firstHelpCommentLink.click();
    }
    //endregion

    //region Assertions
    public void checkFirstHelpStatus(Matcher<WebElement> matcher) {
        assertThat("неверный статус заявки на первую помощь", firstHelpStatus, matcher);
    }
    //endregion
}
