package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.deals.DealInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.List;

import static java.util.stream.Collectors.toList;
import static org.hamcrest.CoreMatchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

@FindBy(css = ".deals-selector-popup_js_inited")
public class DealsPopup extends ExtendedHtmlElement {
    private List<DealsRow> dealsRows;

    @Name("Кнопка сохранить")
    @FindBy(css = ".deals-selector-popup__save")
    private Button saveButton;

    @Name("Кнопка отменить")
    @FindBy(css = ".deals-selector-popup__cancel")
    private Button cancelButton;

    @Name("Спиннер")
    @FindBy(css = ".spin2_progress_yes")
    private WebElement spinner;

    public List<DealInfoWeb> getSelectedDeals() {
        waitForSpinnerIsNotDiplayed();
        return dealsRows.stream().filter(DealsRow::isDealSelected)
                .map(DealsRow::getDeal)
                .collect(toList());
    }

    public void setDealSelectedById(Long id, boolean state) {
        waitForSpinnerIsNotDiplayed();
        dealsRows.stream()
                .filter(deal -> deal.getDeal().getDealId().equals(id))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не найдена сделка с id: " + id))
                .setDealCheckBoxSelected(state);
    }

    public void clickSave() {
        saveButton.click();
    }

    public void clickCancelButton() {
        cancelButton.click();
    }

    public void checkDealRowsAreDisabled(Long... dealIds) {
        dealsRows.stream().filter(deal -> ArrayUtils.contains(dealIds, deal.getDeal().getDealId()))
                .forEach(DealsRow::checkCheckBoxIsDisabled);
    }

    public void waitForSpinnerIsNotDiplayed() {
        waitForElement(spinner, 30, not(WebElementMatchers.isDisplayed()));
    }
}