package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.deals.DealInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static java.lang.String.format;
import static org.hamcrest.CoreMatchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@FindBy(css = ".b-chooser__item")
public class DealsRow extends ExtendedHtmlElement {
    @Name("Чекбокс сделки")
    @FindBy(css = ".checkbox__control")
    private CheckBoxBEM dealCheckBox;

    @Name("Имя сделки")
    @FindBy(css = ".deals-selector__name")
    private WebElement dealName;

    @Name("Номер сделки")
    @FindBy(css = ".deals-selector__addition")
    private WebElement dealId;

    public DealInfoWeb getDeal() {
        return new DealInfoWeb()
                .withDealId(getDealId())
                .withDealName(dealName.getText());
    }

    public boolean isDealSelected() {
        return dealCheckBox.isSelected();
    }

    public void setDealCheckBoxSelected(boolean state) {
        if (dealCheckBox.isSelected() ^ state) {
            click();
        }
    }

    private Long getDealId() {
        return Long.parseLong(dealId.getText());
    }

    public void checkCheckBoxIsDisabled() {
        assertThat(format("чек-бокс сделки id: %d соответствует ожиданию", getDealId()), dealCheckBox.getWrappedElement(),
                not(WebElementMatchers.isEnabled()));
    }
}
