package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 07.09.14
 */

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.allure.webdriver.steps.WebDriverSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;


@Name("Попап меток")
@FindBy(xpath = ".//div[contains(@class, 'b-group-tags-groupedit ')]")
public class GroupEditTagsPopup extends ExtendedHtmlElement {

    @Name("Новые метки")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-tags-groupedit__new-tags')]//input")
    private TextInput newTagsTextInput;

    @Name("Сохранить")
    @FindBy(xpath = ".//button[contains(@class, 'b-group-tags-groupedit__submit')]")
    private Button saveButton;

    public void saveNewTags(String... tags) {
        fillTextInput(newTagsTextInput, StringUtils.join(tags, ","));
        WebDriverSteps.getInstance(WebDriverSteps.class, config).takeScreenshot();
        saveButton.click();
    }
}
