package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases.BannerDynamicTargetRowBlockBEM;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases.BannerSmartFilterRowBlockBEM;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import static java.lang.Long.parseLong;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

@FindBy(css = ".b-campaign-group")
public class GroupPreviewWithPhrasesBlockBEM extends ExtendedHtmlElement {

    @Name("ID группы баннеров")
    @FindBy(xpath = ".//a[contains(@class, 'b-campaign-group__anchor')]")
    private WebElement groupLabel;

    @Name("ID первого баннера")
    @FindBy(css = "div.b-banner-preview2")
    private WebElement bannerId;

    @Name("Чекбокс баннера")
    @FindBy(xpath = ".//span[contains(@class, 'b-checkboxes-group__item')]//input")
    private CheckBoxBEM checkbox;

    @Name("Заголовок баннера")
    @FindBy(css = "div.b-banner-preview2__title a")
    private Link bannerTitle;

    @Name("Текст баннера")
    @FindBy(css = "div.b-banner-preview2__body")
    private WebElement bannerBody;

    @Name("Адрес и телефон")
    @FindBy(xpath = ".//span[contains(@class, 'v-card')]")
    private WebElement vCard;

    @Name("Домен")
    @FindBy(css = "div.b-banner-preview2__domain")
    private WebElement bannerDomain;

    @Name("Регионы показа")
    @FindBy(css = "div.b-group-regions__names")
    private WebElement bannerGeo;

    //Попап отображается, когда список регионов не помещается в превью
    @Name("Регионы показа в попапе")
    @FindBy(xpath = ".//div[contains(@class,'b-group-regions__names-popup')]")
    private WebElement bannerGeoPopup;

    @Name("Попап сайтлинков")
    @FindBy(xpath = "//div[contains(@class, 'b-banner-preview2__sitelinks')]")
    private BannerPreviewContentBlockBEM.SiteLinksPopup siteLinksPopup;

    @Name("Заголовок превью")
    @FindBy(css = "div.b-campaign-group__group-title")
    private WebElement groupTitle;

    @Name("Ссылка открытия блока объявлений группы")
    @FindBy(xpath = ".//span[contains(@class, 'b-campaign-group__group-toggle')]//button")
    private WebElement groupToggleLink;

    @Name("Количество объявлений в группе")
    @FindBy(xpath = ".//span[contains(@class, 'b-campaign-group__group-toggle-text')]")
    private WebElement groupBannerCount;

    @Name("Ссылка редактирования группы")
    @FindBy(xpath = ".//a[contains(@href, 'groups-edit')]")
    private Link editGroupLink;

    @Name("Ссылка копирования баннера/группы")
    @FindBy(xpath = ".//a[contains(@href, 'is_groups_copy_action=1')]")
    private WebElement copyGroupLink;

    @Name("Ссылка Остановить для группы баннеров")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=stopAdGroup')]")
    private WebElement stopBannerGroup;

    @Name("Ссылка возобновить для группы баннеров")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=resumeAdGroup')]")
    private WebElement activateBannerGroup;

    @Name("Ссылка отправить группу на модерацию")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=sendModerate')]")
    private WebElement sendGroupToModeration;

    @Name("Ссылка удалить")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=deleteAdGroup')]")
    private WebElement deleteLink;

    @Name("Ссылка редактирования медиаплана")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=multieditMediaplan')]")
    private WebElement editMediaplanLink;

    @Name("Минус-слова на объявление")
    @FindBy(xpath = ".//a[contains(@class, 'b-minus-words-control__switcher-link')]")
    private WebElement minusWords;

    @Name("Попап минус слов")
    @FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible')]//div[contains(@class, 'b-outboard-controls__popup-content')]")
    private MinusKeywordsPopup minusKeywordsPopup;

    @Name("Кнопка открытия попапа меток банера")
    @FindBy(css = ".b-group-tag-button__content")
    private WebElement openTagsPopupButton;

    @Name("Предупреждение баннера")
    @FindBy(css = "div.b-banner-adv-alert2__warn")
    private WebElement bannerFlag;

    @Name("Ссылка Изменить предупреждение")
    @FindBy(css = "span.b-banner-adv-alert2__link_action_change span")
    private Link changeBannersFlagLink;

    @Name("флаг БАД")
    @FindBy(css = "span.checkbox_name_dietarysuppl input")
    private CheckBoxBEM dietarySupplFlag;

    private BannerTagsPopupBlock bannerTagsPopupBlock;

    @FindBy(css = ".b-campaign-group__preview")
    private BannerPreviewContentBlockBEM bannerPreviewBlockBEM;

    @FindBy(css = ".b-banner-preview2_view_mobile-content-campaign")
    private MobileAppBannerPreviewContentBlockBEM mobileAppBannerPreviewContentBlockBEM;

    @Name("Ссылка открытия блока автокоррекции")
    @FindBy(xpath = ".//div[contains(@class, 'b-banner-errata-informer')]//span[contains(@class, 'link')]")
    private WebElement openInformer;

    @Name("Блок автокоррекции")
    @FindBy(xpath = ".//div[contains(@class, 'b-banner-errata-informer')]")
    private WebElement autoCorrectionMessage;

    @Name("Ссылка открытия блока дополнений на баннер")
    @FindBy(xpath = ".//div[@class='b-banner-preview2__additions']//span[@class='link__inner']")
    private WebElement openBannerAdditionsPopup;

    @Name("Таблица со ставками")
    @FindBy(xpath = ".//td[contains(@class,'b-campaign-group__phrases')]")
    private WebElement phrasesBlock;

    List<BannerDynamicTargetRowBlockBEM> dynamicTargetRowBlock;
    List<BannerSmartFilterRowBlockBEM> smartFilterRowBlock;

    private BannerTagsPopupBlock getBannerTagsPopupBlock() {
        bannerTagsPopupBlock.setConfig(config);
        return bannerTagsPopupBlock;
    }

    public void clickGroupToggleLink() {
        new JavaScriptActions(config).scrollToElement(groupToggleLink);
        groupToggleLink.click();
    }

    public void clickOpenInformer() {
        new JavaScriptActions(config).scrollToElement(openInformer);
        openInformer.click();
    }

    public void shouldSeeAutoCorrection(Matcher<WebElement> matcher) {
        MatcherAssert.assertThat("состояние сообщения об автокоррекции отличается от ожидаемого", autoCorrectionMessage,
                matcher);
    }

    public void waitForBannerGroupPreviewBlock(Matcher<WebElement> matcher) {
        bannerPreviewBlockBEM.waitForBannerGroupPreviewBlock(matcher);
    }

    public void waitForSpinLoader(Matcher matcher) {
        bannerPreviewBlockBEM.waitForSpinLoader(matcher);
    }

    public String getBannerGroupTitle() {
        return groupTitle.getText();
    }

    public void checkBannerGroupTitle(Matcher<WebElement> matcher) {
        assertThat("ссылка открытия попапа группы не удовлетворяет условию", groupToggleLink, matcher);
    }

    public void checkBannerGroupCount(Matcher matcher) {
        assertThat("число баннеров в группе не соответсвует ожиданиям",
                groupBannerCount.getText().replaceAll("\\D", ""),
                matcher);
    }

    public void clickMinusWords() {
        new JavaScriptActions(config).scrollToElement(minusWords);
        minusWords.click();
    }

    private MinusKeywordsPopup getMinusKeywordsPopup() {
        minusKeywordsPopup.setConfig(config);
        return minusKeywordsPopup;
    }

    public void fillMinusKeywordsAndSave(String keywords) {
        new JavaScriptActions(config).scrollToElement(minusWords);
        minusWords.click();
        takeScreenshot();
        getMinusKeywordsPopup().fillMinusKeywordsAndSave(keywords);
    }

    public void fillNewTags(String... tags) {
        getBannerTagsPopupBlock().fillNewTags(tags);
    }

    public void setTagCheckBoxes(String... tags) {
        getBannerTagsPopupBlock().setTagCheckBoxes(tags);
    }

    public void clickSaveTags() {
        getBannerTagsPopupBlock().clickOnSaveButton();
    }

    public void clickStopBannerGroup() {
        new JavaScriptActions(config).scrollToElement(stopBannerGroup);
        stopBannerGroup.click();
    }

    public void clickOnOpenTags() {
        new JavaScriptActions(config).scrollToElement(openTagsPopupButton);
        openTagsPopupButton.click();
    }

    public void clickEditMediaplan() {
        new JavaScriptActions(config).scrollToElement(editMediaplanLink);
        editMediaplanLink.click();
    }

    public void clickActivateBannerGroup() {
        new JavaScriptActions(config).scrollToElement(activateBannerGroup);
        activateBannerGroup.click();
    }

    public void clickSendGroupToModeration() {
        new JavaScriptActions(config).scrollToElement(sendGroupToModeration);
        sendGroupToModeration.click();
    }

    public void deleteBanner() {
        new JavaScriptActions(config).scrollToElement(deleteLink);
        deleteLink.click();
    }

    public void selectBanner() {
        new JavaScriptActions(config).scrollToElement(checkbox.getWrappedElement());
        checkbox.select();
    }

    public void deselectBanner() {
        new JavaScriptActions(config).scrollToElement(checkbox.getWrappedElement());
        checkbox.deselect();
    }

    public Long getAdGroupID() {
        return parseLong(groupLabel.getAttribute("name"));
    }

    public void clickOnEditGroupLink() {
        new JavaScriptActions(config).scrollToElement(editGroupLink.getWrappedElement());
        editGroupLink.click();
    }

    public void clickOnCopyGroupLink() {
        new JavaScriptActions(config).scrollToElement(copyGroupLink);
        copyGroupLink.click();
    }

    public void clickOnBannerAdditionsLink() {
        openBannerAdditionsPopup.click();
    }

    public void checkEditGroupLink(Matcher<WrapsElement> matcher) {
        assertThat(editGroupLink, matcher);
    }

    public void checkBannerFlag(Matcher<WebElement> matcher) {
        assertThat("предупреждение баннера не удовлетворяет условию", bannerFlag, matcher);
    }

    public void setDietarySupplBannerFlag() {
        changeBannersFlagLink.click();
        dietarySupplFlag.select();
    }


    public void checkBannerParameters(BannerInfoWeb expectedBean) {
        expectedBean.setAdGroupID(null);
        bannerPreviewBlockBEM.checkParameters(expectedBean);
    }

    public void checkBannerOnGroupPreview(Long BannerID, Matcher matcher) {
        bannerPreviewBlockBEM.checkBannerOnGroupPreview(BannerID, matcher);
    }

    public void checkMobileAppBannerParameters(MobileAppBannerInfoWeb expectedBean) {
        expectedBean.setAdGroupID(null);
        mobileAppBannerPreviewContentBlockBEM.checkParameters(expectedBean);
    }

    public Long getBannerId() {
        Pattern pattern = Pattern.compile("\"(id|bannerId)\".?:.?\"(\\d+)\"");
        java.util.regex.Matcher matcher = pattern.matcher(bannerId.getAttribute("data-bem"));
        if (matcher.find()) {
            return parseLong(matcher.group(2));
        } else {
            throw new DirectWebError("Cannot find banner Id");
        }
    }

    public WebElement getPhrasesBlock() {
        return this.phrasesBlock;
    }

    private List<BannerDynamicTargetRowBlockBEM> getDynamicTargetRowBlock() {
        return dynamicTargetRowBlock;
    }

    public BannerDynamicTargetRowBlockBEM getDynamicTargetRowByName(String targetName) {
        BannerDynamicTargetRowBlockBEM rowBlock =
                getDynamicTargetRowBlock().stream().filter(t -> targetName.equals(t.getDynamicTargetName())).findFirst()
                        .
                                orElseThrow(() -> new DirectWebError("Не найдено условие показа " + targetName));
        rowBlock.setConfig(config);
        return rowBlock;
    }

    private List<BannerSmartFilterRowBlockBEM> getSmartFilterRowBlock() {
        return smartFilterRowBlock;
    }

    public BannerSmartFilterRowBlockBEM getSmartFilterRowByName(String filterName) {
        BannerSmartFilterRowBlockBEM rowBlock =
                getSmartFilterRowBlock().stream().filter(t -> filterName.equals(t.getSmartFilterName())).findFirst().
                        orElseThrow(() -> new DirectWebError("Не найден фильтр " + filterName));
        rowBlock.setConfig(config);
        return rowBlock;
    }

    @Name("Попап минус-слов")
    public static class MinusKeywordsPopup extends ExtendedHtmlElement {

        @Name("Минус слова")
        @FindBy(xpath = ".//textarea[contains(@class, 'input__control')]")
        private WebElement minusKeywords;

        @Name("Кнопка сохранить")
        @FindBy(xpath = ".//button[contains(@class, 'b-outboard-controls__accept-button ')]")
        private Button saveButton;

        public void fillMinusKeywordsAndSave(String keywords) {
            minusKeywords.click();
            minusKeywords.clear();
            minusKeywords.sendKeys(keywords);
            takeScreenshot();
            saveButton.click();
        }
    }

    public void checkVCard(Matcher<WebElement> matcher) {
        assertThat("стостояние визитки не верное", vCard, matcher);
    }

    @Name("Попап меток объявлений")
    @FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible') and contains(@class, 'b-group-tags__popup')]")
    public static class BannerTagsPopupBlock extends ExtendedHtmlElement {

        @Name("Метки")
        @FindBy(css = ".b-group-tags-popup-content__checkbox input")
        private List<CheckBoxBEM> tagCheckBoxes;

        @Name("Новые метки")
        @FindBy(css = ".b-group-tags-popup-content__new-tags input")
        private TextInput newTagsTextInput;

        @Name("Сохранить")
        @FindBy(css = ".b-outboard-controls__accept-button")
        private Button saveButton;

        private CheckBoxBEM getTagCheckBox(String tag) {
            for (CheckBoxBEM tagCheckBox : tagCheckBoxes) {
                if (tagCheckBox.getText().equalsIgnoreCase(tag)) {
                    return tagCheckBox;
                }
            }
            return null;
        }

        public List<String> getTags() {
            List<String> tags = new ArrayList<>();
            for (CheckBoxBEM tagCheckBox : tagCheckBoxes) {
                if (tagCheckBox.isSelected()) {
                    tags.add(tagCheckBox.getText());
                }
            }
            return tags;
        }

        public void fillNewTags(String... tags) {
            fillTextInput(newTagsTextInput, StringUtils.join(tags, ","));
        }

        public void clickOnSaveButton() {
            saveButton.click();
        }

        public void setTagCheckBoxes(String... tags) {
            for (String tag : tags) {
                CheckBoxBEM tagCheckBox = getTagCheckBox(tag);
                if (tagCheckBox == null) {
                    throw new DirectWebError("не найден checkBox метки " + tag);
                } else {
                    setCheckboxState(tagCheckBox, true);
                }
            }
            takeScreenshot();
            saveButton.click();
        }
    }
}
