package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Created by shmykov on 12.08.14.
 */
@Name("Попап панель медиаплана")
@FindBy(xpath = "//div[contains(@class, 'popup__content')][.//a[contains(@href, 'cmd=createMediaplan')]]")
public class MediaplanPopupBlock extends HtmlElement {

    @Name("Создать медиаплан")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=createMediaplan')]")
    private WebElement createMediaplanLink;

    @Name("Отправить заявку на медиаплан")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=sendRequestMediaplan')]")
    private WebElement sendRequestMediaplanLink;

    @Name("Выгрузить медиаплан в Excel")
    @FindBy(xpath = ".//a[contains(@href, '.xls') and not(contains(@href, 'for=big'))]")
    private WebElement exportToExcelLink;

    public void clickCreateMediaplanLink() {
        createMediaplanLink.click();
    }

    public void clickSendRequestMediaplanLink() {
        sendRequestMediaplanLink.click();
    }

    public String getExportToExcelLink() {
        return exportToExcelLink.getAttribute("href");
    }
}
