package ru.yandex.autotests.direct.web.pages.showcampbem.blocks;

import java.util.List;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

@FindBy(css = ".b-strategy2-choose__strategies")
public class NewStrategyChooseBlock extends HtmlElement {

    @FindBy(css = ".b-chooser__item[data-bem]")
    private List<WebElement> strategyChooseItems;

    @FindBy(css = ".b-chooser__item[data-bem].b-chooser__item_selected_yes")
    private WebElement selectedStrategy;

    public void selectStrategy(String name) {
        for (WebElement strategyChooseItem : strategyChooseItems) {
            if (name.equals(getStrategyName(strategyChooseItem))) {
                strategyChooseItem.click();
                return;
            }
        }
        throw new DirectWebError("Не удалось найти стратегию " + name);
    }

    public String getSelectedStrategy() {
        return getStrategyName(selectedStrategy);
    }

    private String getStrategyName(WebElement element) {
        DataBem value = getDataBem(element.getAttribute("data-bem"));
        return value.dataBem.extraParams.origName;
    }

    private DataBem getDataBem(String value) {
        return new Gson().fromJson(value, DataBem.class);
    }

    private class DataBem {
        @SerializedName("b-chooser__item")
        private DataBemValue dataBem = new DataBemValue();

        private class DataBemValue {
            @SerializedName("extraParams")
            private ExtraParams extraParams = new ExtraParams();

            private class ExtraParams {
                @SerializedName("origName")
                private String origName = "";
            }
        }
    }
}
