package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ch.lambdaj.Lambda.on;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@FindBy(css = ".b-banner-errata")
public class AutoCorrectionPopupBlock extends HtmlElement {

    @Name("Название баннера")
    @FindBy(css = ".b-banner-errata__preview-title")
    private WebElement title;

    @Name("Текст баннера")
    @FindBy(css = ".b-banner-errata__preview-body")
    private WebElement body;

    public void checkBeforeAutoCorrectionBanner(BannerInfoWeb expectedBean) {
        assertThat("параметры баннера соответствуют ожидаемым",
                getFormFieldsAccording(expectedBean), beanDiffer(expectedBean));
    }

    public BannerInfoWeb getFormFieldsAccording(BannerInfoWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(BannerInfoWeb.class)
                .set("title", title, on(WebElement.class).getText())
                .set("text", body, on(WebElement.class).getText())
                .getActualBean();
    }
}
