package ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;

/**
 * Created by shmykov on 30.05.14.
 */
@Name("Блок - превью группы баннера")
@FindBy(xpath = "//div[contains(@class, 'b-group-preview2 ')]")
public class BannerGroupPreviewBlock extends ExtendedHtmlElement {

    @Name("Список объявлений в блоке")
    @FindBy(xpath = "//div[contains(@class, 'b-group-preview2__banner-item')]")
    private List<WebElement> bannersList;

    @Name("Крутящаяся заглушка при загрузке")
    @FindBy(xpath = "//div[contains(@class, 'b-group-preview__paranja')]")
    private WebElement spinLoader;

    public WebElement getSpinLoader () {
        return spinLoader;
    }

    public WebElement getBannerOnGroupPreviewBlock(Long bannerID) {
        for (WebElement banner : bannersList) {
            if (banner.getAttribute("class").contains(String.valueOf(bannerID))) {
                return banner;
            }
        }
        return null;
    }
}
